/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ByteArrayKey;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.CSAIntegrationTest")
public class CSAIntegrationTest
extends HitsAwareCacheManagersTest {
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    private HotRodServer hotRodServer3;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;
    private TcpTransportFactory tcpConnectionFactory;
    private static final Log log = LogFactory.getLog(CSAIntegrationTest.class);
    private Marshaller m;

    @BeforeTest
    public void createMarshaller() {
        this.m = new GenericJBossMarshaller();
    }

    @AfterTest
    public void destroyMarshaller() {
        this.m = null;
    }

    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    protected void createCacheManagers() throws Throwable {
        Configuration config = CSAIntegrationTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
        config.setNumOwners(1);
        config.setUnsafeUnreliableReturnValues(true);
        this.addClusterEnabledCacheManager(config);
        this.addClusterEnabledCacheManager(config);
        this.addClusterEnabledCacheManager(config);
        this.hotRodServer1 = TestHelper.startHotRodServer(this.manager(0));
        this.hrServ2CacheManager.put(new InetSocketAddress(this.hotRodServer1.getHost(), this.hotRodServer1.getPort()), this.manager(0));
        this.hotRodServer2 = TestHelper.startHotRodServer(this.manager(1));
        this.hrServ2CacheManager.put(new InetSocketAddress(this.hotRodServer2.getHost(), this.hotRodServer2.getPort()), this.manager(1));
        this.hotRodServer3 = TestHelper.startHotRodServer(this.manager(2));
        this.hrServ2CacheManager.put(new InetSocketAddress(this.hotRodServer3.getHost(), this.hotRodServer3.getPort()), this.manager(2));
        assert (this.manager(0).getCache() != null);
        assert (this.manager(1).getCache() != null);
        assert (this.manager(2).getCache() != null);
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)3, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(0).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(1).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(2).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        this.manager(0).getCache().put((Object)"k", (Object)"v");
        this.manager(0).getCache().get((Object)"k").equals("v");
        this.manager(1).getCache().get((Object)"k").equals("v");
        this.manager(2).getCache().get((Object)"k").equals("v");
        log.info((Object)"Local replication test passed!");
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer2.getPort() + ";localhost:" + this.hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "false");
        this.setHotRodProtocolVersion(props);
        this.remoteCacheManager = new RemoteCacheManager(props);
        this.remoteCache = this.remoteCacheManager.getCache();
        this.tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transportFactory");
    }

    protected void setHotRodProtocolVersion(Properties props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        try {
            if (this.remoteCacheManager != null) {
                this.remoteCacheManager.stop();
            }
        }
        finally {
            try {
                try {
                    if (this.hotRodServer1 != null) {
                        this.hotRodServer1.stop();
                    }
                }
                finally {
                    try {
                        if (this.hotRodServer2 != null) {
                            this.hotRodServer2.stop();
                        }
                    }
                    finally {
                        if (this.hotRodServer3 != null) {
                            this.hotRodServer3.stop();
                        }
                    }
                }
            }
            finally {
                super.destroy();
            }
        }
    }

    public void testHashInfoRetrieved() throws InterruptedException {
        assert (this.tcpConnectionFactory.getServers().size() == 3);
        for (int i = 0; i < 10; ++i) {
            this.remoteCache.put((Object)"k", (Object)"v");
            if (this.tcpConnectionFactory.getServers().size() == 3) break;
            Thread.sleep(1000L);
        }
        AssertJUnit.assertEquals((int)3, (int)this.tcpConnectionFactory.getServers().size());
        AssertJUnit.assertNotNull((Object)this.tcpConnectionFactory.getConsistentHash());
    }

    @Test(dependsOnMethods={"testHashInfoRetrieved"})
    public void testCorrectSetup() {
        this.remoteCache.put((Object)"k", (Object)"v");
        assert (this.remoteCache.get((Object)"k").equals("v"));
    }

    @Test(dependsOnMethods={"testCorrectSetup"})
    public void testHashFunctionReturnsSameValues() {
        for (int i = 0; i < 1000; ++i) {
            byte[] key = this.generateKey(i);
            TcpTransport transport = (TcpTransport)this.tcpConnectionFactory.getTransport(key);
            InetSocketAddress serverAddress = transport.getServerAddress();
            CacheContainer cacheContainer = (CacheContainer)this.hrServ2CacheManager.get(serverAddress);
            AssertJUnit.assertNotNull((String)("For server address " + serverAddress + " found " + cacheContainer + ". Map is: " + this.hrServ2CacheManager), (Object)cacheContainer);
            DistributionManager distributionManager = cacheContainer.getCache().getAdvancedCache().getDistributionManager();
            assert (distributionManager.getLocality((Object)key).isLocal());
            this.tcpConnectionFactory.releaseTransport((Transport)transport);
        }
    }

    @Test(dependsOnMethods={"testHashFunctionReturnsSameValues"})
    public void testRequestsGoToExpectedServer() throws Exception {
        TcpTransport transport;
        byte[] keyBytes;
        String keyStr;
        this.addInterceptors();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (int i = 0; i < 500; ++i) {
            byte[] key = this.generateKey(i);
            keys.add(key);
            keyStr = new String(key);
            this.remoteCache.put((Object)keyStr, (Object)"value");
            keyBytes = this.m.objectToByteBuffer((Object)keyStr);
            transport = (TcpTransport)this.tcpConnectionFactory.getTransport(keyBytes);
            this.assertCacheContainsKey(transport.getServerAddress(), keyBytes);
            this.tcpConnectionFactory.releaseTransport((Transport)transport);
        }
        log.info((Object)"Right before first get.");
        for (byte[] key : keys) {
            this.resetStats();
            keyStr = new String(key);
            assert (this.remoteCache.get((Object)keyStr).equals("value"));
            keyBytes = this.m.objectToByteBuffer((Object)keyStr);
            transport = (TcpTransport)this.tcpConnectionFactory.getTransport(keyBytes);
            this.assertOnlyServerHit(transport.getServerAddress());
            this.tcpConnectionFactory.releaseTransport((Transport)transport);
        }
    }

    private void assertCacheContainsKey(InetSocketAddress serverAddress, byte[] keyBytes) {
        CacheContainer cacheContainer = (CacheContainer)this.hrServ2CacheManager.get(serverAddress);
        Cache cache = cacheContainer.getCache();
        DataContainer dataContainer = cache.getAdvancedCache().getDataContainer();
        assert (dataContainer.keySet().contains(new ByteArrayKey(keyBytes)));
    }

    private byte[] generateKey(int i) {
        Random r = new Random();
        byte[] result = new byte[i];
        r.nextBytes(result);
        return result;
    }
}

