/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.config.Configuration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.HotRodServerStartStopTest", groups={"functional"})
public class HotRodServerStartStopTest
extends MultipleCacheManagersTest {
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;

    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    protected void createCacheManagers() throws Throwable {
        Configuration config = HotRodServerStartStopTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.DIST_SYNC);
        this.addClusterEnabledCacheManager(config);
        this.addClusterEnabledCacheManager(config);
        this.hotRodServer1 = TestHelper.startHotRodServer(this.manager(0));
        this.hotRodServer2 = TestHelper.startHotRodServer(this.manager(1));
        assert (this.manager(0).getCache() != null);
        assert (this.manager(1).getCache() != null);
        this.waitForClusterToForm();
        this.cache(0).put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)this.cache(1).get((Object)"k"));
    }

    public void testTouchServer() {
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager("localhost", this.hotRodServer1.getPort(), true);
        RemoteCache remoteCache = remoteCacheManager.getCache();
        remoteCache.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)remoteCache.get((Object)"k"));
    }

    @Test(dependsOnMethods={"testTouchServer"})
    public void testHrServerStop() {
        this.hotRodServer1.stop();
        this.hotRodServer2.stop();
    }
}

