/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Collections;
import java.util.Properties;
import junit.framework.Assert;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.RemoteAsyncAPITest")
public class RemoteAsyncAPITest
extends SingleCacheManagerTest {
    private HotRodServer hotrodServer;
    private RemoteCacheManager rcm;
    private RemoteCache<String, String> c;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        this.cache = cm.getCache();
        this.hotrodServer = TestHelper.startHotRodServer(cm);
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.hotrodServer.getPort());
        props.put("infinispan.client.hotrod.force_return_values", "true");
        props.put("testOnBorrow", "false");
        this.rcm = new RemoteCacheManager(props);
        this.c = this.rcm.getCache(true);
        return cm;
    }

    @AfterClass
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        this.rcm.stop();
        this.hotrodServer.stop();
    }

    public void testAsyncPut() throws Exception {
        NotifyingFuture f = this.c.putAsync((Object)"k", (Object)"v");
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (((String)this.c.get((Object)"k")).equals("v"));
        f = this.c.putAsync((Object)"k", (Object)"v2");
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v")) : "Obtained " + (String)f.get();
        assert (((String)this.c.get((Object)"k")).equals("v2"));
    }

    public void testAsyncPutAll() throws Exception {
        NotifyingFuture f2 = this.c.putAllAsync(Collections.singletonMap("k", "v3"));
        assert (f2 != null);
        assert (!f2.isCancelled());
        assert (f2.get() == null);
        assert (f2.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v3"));
    }

    public void testAsyncPutIfAbsent() throws Exception {
        NotifyingFuture f2 = this.c.putAllAsync(Collections.singletonMap("k", "v3"));
        assert (f2.get() == null);
        assert (f2.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v3"));
        NotifyingFuture f = this.c.putIfAbsentAsync((Object)"k", (Object)"v4");
        assert (f != null);
        assert (!f.isCancelled());
        assert ("v3".equals(f.get())) : "Obtained " + f.get();
        assert (f.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v3"));
    }

    public void testRemoveAsync() throws Exception {
        this.c.put((Object)"k", (Object)"v3");
        NotifyingFuture f = this.c.removeAsync((Object)"k");
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v3"));
        assert (f.isDone());
        assert (this.c.get((Object)"k") == null);
    }

    public void testPutIfAbsentAsync() throws Exception {
        NotifyingFuture f = this.c.putIfAbsentAsync((Object)"k", (Object)"v4");
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v4"));
    }

    public void testAsyncGet() throws Exception {
        NotifyingFuture f = this.c.putAsync((Object)"k", (Object)"v");
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (((String)this.c.get((Object)"k")).equals("v"));
        f = this.c.getAsync((Object)"k");
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v")) : "Obtained " + (String)f.get();
        assert (((String)this.c.get((Object)"k")).equals("v"));
    }

    public void testVersionedRemove() throws Exception {
        this.c.put((Object)"k", (Object)"v4");
        VersionedValue value = this.c.getVersioned((Object)"k");
        NotifyingFuture f3 = this.c.removeWithVersionAsync((Object)"k", value.getVersion() + 1L);
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (f3.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v4"));
        f3 = this.c.removeWithVersionAsync((Object)"k", value.getVersion());
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (f3.isDone());
        assert (this.c.get((Object)"k") == null);
    }

    public void testReplaceAsync() throws Exception {
        NotifyingFuture f = this.c.replaceAsync((Object)"k", (Object)"v5");
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (this.c.get((Object)"k") == null);
        assert (f.isDone());
        this.c.put((Object)"k", (Object)"v");
        f = this.c.replaceAsync((Object)"k", (Object)"v5");
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get().equals("v"));
        assert (((String)this.c.get((Object)"k")).equals("v5"));
        assert (f.isDone());
    }

    public void testVersionedReplace() throws Exception {
        assert (null == this.c.replace((Object)"aKey", (Object)"aValue"));
        this.c.put((Object)"aKey", (Object)"aValue");
        VersionedValue valueBinary = this.c.getVersioned((Object)"aKey");
        NotifyingFuture future = this.c.replaceWithVersionAsync((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion());
        assert (!future.isCancelled());
        assert (((Boolean)future.get()).booleanValue());
        assert (future.isDone());
        VersionedValue entry2 = this.c.getVersioned((Object)"aKey");
        assert (entry2.getVersion() != valueBinary.getVersion());
        Assert.assertEquals((Object)entry2.getValue(), (Object)"aNewValue");
        assert (!this.c.replaceWithVersion((Object)"aKey", (Object)"aNewValue", valueBinary.getVersion()));
    }
}

