/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="client.hotrod.RoundRobinBalancingStrategyTest")
public class RoundRobinBalancingStrategyTest {
    SocketAddress addr1 = new InetSocketAddress("localhost", 1111);
    SocketAddress addr2 = new InetSocketAddress("localhost", 2222);
    SocketAddress addr3 = new InetSocketAddress("localhost", 3333);
    SocketAddress addr4 = new InetSocketAddress("localhost", 4444);
    private List<SocketAddress> defaultServers;
    private RoundRobinBalancingStrategy strategy;

    @BeforeMethod
    public void setUp() {
        this.strategy = new RoundRobinBalancingStrategy();
        this.defaultServers = new ArrayList<SocketAddress>();
        this.defaultServers.add(this.addr1);
        this.defaultServers.add(this.addr2);
        this.defaultServers.add(this.addr3);
        this.strategy.setServers(this.defaultServers);
    }

    public void simpleTest() {
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
    }

    public void testAddServer() {
        ArrayList<SocketAddress> newServers = new ArrayList<SocketAddress>(this.defaultServers);
        newServers.add(this.addr4);
        this.strategy.setServers(newServers);
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr4, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr4, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
    }

    public void testRemoveServer() {
        ArrayList<SocketAddress> newServers = new ArrayList<SocketAddress>(this.defaultServers);
        newServers.remove(this.addr3);
        this.strategy.setServers(newServers);
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
    }

    public void testRemoveServerAfterActivity() {
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        ArrayList<SocketAddress> newServers = new ArrayList<SocketAddress>(this.defaultServers);
        newServers.remove(this.addr3);
        this.strategy.setServers(newServers);
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
    }

    public void testAddServerAfterActivity() {
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        ArrayList<SocketAddress> newServers = new ArrayList<SocketAddress>(this.defaultServers);
        newServers.add(this.addr4);
        this.strategy.setServers(newServers);
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr4, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr4, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr1, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr2, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr3, (Object)this.strategy.nextServer());
        AssertJUnit.assertEquals((Object)this.addr4, (Object)this.strategy.nextServer());
    }
}

