/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.BeforeMethod;

public abstract class HitsAwareCacheManagersTest
extends MultipleCacheManagersTest {
    protected Map<InetSocketAddress, CacheContainer> hrServ2CacheManager = new HashMap<InetSocketAddress, CacheContainer>();
    protected Map<InetSocketAddress, HotRodServer> addr2hrServer = new HashMap<InetSocketAddress, HotRodServer>();

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() throws Throwable {
        if (this.cleanupAfterMethod()) {
            this.hrServ2CacheManager.clear();
            this.addr2hrServer.clear();
        }
        super.createBeforeMethod();
    }

    protected HitCountInterceptor getHitCountInterceptor(Cache<Object, Object> cache) {
        HitCountInterceptor hitCountInterceptor = null;
        List interceptorChain = cache.getAdvancedCache().getInterceptorChain();
        for (CommandInterceptor interceptor : interceptorChain) {
            boolean isHitCountInterceptor = interceptor instanceof HitCountInterceptor;
            if (hitCountInterceptor != null && isHitCountInterceptor) {
                throw new IllegalStateException("Two HitCountInterceptors! " + interceptorChain);
            }
            if (!isHitCountInterceptor) continue;
            hitCountInterceptor = (HitCountInterceptor)interceptor;
        }
        return hitCountInterceptor;
    }

    protected void assertOnlyServerHit(SocketAddress serverAddress) {
        CacheContainer cacheContainer = this.hrServ2CacheManager.get(serverAddress);
        HitCountInterceptor interceptor = this.getHitCountInterceptor((Cache<Object, Object>)cacheContainer.getCache());
        assert (interceptor.getHits() == 1) : "Expected one hit but received " + interceptor.getHits();
        for (CacheContainer cm : this.hrServ2CacheManager.values()) {
            if (cm == cacheContainer) continue;
            interceptor = this.getHitCountInterceptor((Cache<Object, Object>)cm.getCache());
            assert (interceptor.getHits() == 0) : "Expected 0 hits but got " + interceptor.getHits();
        }
    }

    protected void assertNoHits() {
        for (CacheContainer cm : this.hrServ2CacheManager.values()) {
            HitCountInterceptor interceptor = this.getHitCountInterceptor((Cache<Object, Object>)cm.getCache());
            assert (interceptor.getHits() == 0) : "Expected 0 hits but got " + interceptor.getHits();
        }
    }

    protected InetSocketAddress getAddress(HotRodServer hotRodServer) {
        InetSocketAddress socketAddress = new InetSocketAddress(hotRodServer.getHost(), hotRodServer.getPort());
        this.addr2hrServer.put(socketAddress, hotRodServer);
        return socketAddress;
    }

    protected void resetStats() {
        for (EmbeddedCacheManager manager : this.cacheManagers) {
            HitCountInterceptor cmi = this.getHitCountInterceptor((Cache<Object, Object>)manager.getCache());
            cmi.reset();
        }
    }

    protected void addInterceptors() {
        for (EmbeddedCacheManager manager : this.cacheManagers) {
            this.addHitCountInterceptor((Cache<Object, Object>)manager.getCache());
        }
    }

    private void addHitCountInterceptor(Cache<Object, Object> cache) {
        HitCountInterceptor interceptor = new HitCountInterceptor();
        cache.getAdvancedCache().addInterceptor((CommandInterceptor)interceptor, 1);
    }

    private InetSocketAddress getHotRodServerAddress(Cache<Object, Object> cache) {
        InetSocketAddress addr = null;
        for (Map.Entry<InetSocketAddress, CacheContainer> entry : this.hrServ2CacheManager.entrySet()) {
            if (!entry.getValue().equals(cache.getCacheManager())) continue;
            addr = entry.getKey();
        }
        return addr;
    }

    public static class HitCountInterceptor
    extends CommandInterceptor {
        private volatile int invocationCount;

        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            if (ctx.isOriginLocal()) {
                ++this.invocationCount;
            }
            return super.handleDefault(ctx, command);
        }

        public int getHits() {
            return this.invocationCount;
        }

        public void reset() {
            this.invocationCount = 0;
        }
    }
}

