/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.manager.CacheContainer;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.RoundRobinBalancingIntegrationTest", groups={"functional"})
public class RoundRobinBalancingIntegrationTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(RoundRobinBalancingIntegrationTest.class);
    Cache c1;
    Cache c2;
    Cache c3;
    Cache c4;
    HotRodServer hotRodServer1;
    HotRodServer hotRodServer2;
    HotRodServer hotRodServer3;
    HotRodServer hotRodServer4;
    RemoteCache<String, String> remoteCache;

    protected void assertSupportedConfig() {
    }

    protected void createCacheManagers() throws Throwable {
        this.c1 = TestCacheManagerFactory.createLocalCacheManager((boolean)false).getCache();
        this.c2 = TestCacheManagerFactory.createLocalCacheManager((boolean)false).getCache();
        this.c3 = TestCacheManagerFactory.createLocalCacheManager((boolean)false).getCache();
        this.registerCacheManager(new CacheContainer[]{this.c1.getCacheManager(), this.c2.getCacheManager(), this.c3.getCacheManager()});
        this.hotRodServer1 = TestHelper.startHotRodServer(this.c1.getCacheManager());
        this.hotRodServer2 = TestHelper.startHotRodServer(this.c2.getCacheManager());
        this.hotRodServer3 = TestHelper.startHotRodServer(this.c3.getCacheManager());
        log.trace((Object)("Server 1 port: " + this.hotRodServer1.getPort()));
        log.trace((Object)("Server 2 port: " + this.hotRodServer2.getPort()));
        log.trace((Object)("Server 3 port: " + this.hotRodServer3.getPort()));
        String servers = TestHelper.getServersString(this.hotRodServer1, this.hotRodServer2, this.hotRodServer3);
        log.trace((Object)("Server list is: " + servers));
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(servers);
        this.remoteCache = remoteCacheManager.getCache();
    }

    @AfterTest(alwaysRun=true)
    public void tearDown() {
        this.hotRodServer1.stop();
        this.hotRodServer2.stop();
        this.hotRodServer3.stop();
        this.hotRodServer4.stop();
    }

    public void testRoundRobinLoadBalancing() {
        this.remoteCache.put((Object)"k1", (Object)"v1");
        this.remoteCache.put((Object)"k2", (Object)"v2");
        this.remoteCache.put((Object)"k3", (Object)"v3");
        AssertJUnit.assertEquals((int)1, (int)this.c1.size());
        AssertJUnit.assertEquals((int)1, (int)this.c2.size());
        AssertJUnit.assertEquals((int)1, (int)this.c3.size());
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.remoteCache.get((Object)"k1")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.remoteCache.get((Object)"k2")));
        AssertJUnit.assertEquals((String)"v3", (String)((String)this.remoteCache.get((Object)"k3")));
        this.remoteCache.put((Object)"k4", (Object)"v1");
        this.remoteCache.put((Object)"k5", (Object)"v2");
        this.remoteCache.put((Object)"k6", (Object)"v3");
        this.remoteCache.put((Object)"k7", (Object)"v1");
        this.remoteCache.put((Object)"k8", (Object)"v2");
        this.remoteCache.put((Object)"k9", (Object)"v3");
        AssertJUnit.assertEquals((int)3, (int)this.c1.size());
        AssertJUnit.assertEquals((int)3, (int)this.c2.size());
        AssertJUnit.assertEquals((int)3, (int)this.c3.size());
    }

    @Test(dependsOnMethods={"testRoundRobinLoadBalancing"})
    public void testAddNewHotrodServer() {
        this.c4 = TestCacheManagerFactory.createLocalCacheManager((boolean)false).getCache();
        this.hotRodServer4 = TestHelper.startHotRodServer(this.c4.getCacheManager());
        this.registerCacheManager(new CacheContainer[]{this.c4.getCacheManager()});
        ArrayList<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>();
        serverAddresses.add(new InetSocketAddress("localhost", this.hotRodServer1.getPort()));
        serverAddresses.add(new InetSocketAddress("localhost", this.hotRodServer2.getPort()));
        serverAddresses.add(new InetSocketAddress("localhost", this.hotRodServer3.getPort()));
        serverAddresses.add(new InetSocketAddress("localhost", this.hotRodServer4.getPort()));
        RoundRobinBalancingStrategy balancer = this.getBalancer();
        balancer.setServers(serverAddresses);
        this.remoteCache.put((Object)"k1", (Object)"v1");
        this.remoteCache.put((Object)"k2", (Object)"v2");
        this.remoteCache.put((Object)"k3", (Object)"v3");
        this.remoteCache.put((Object)"k4", (Object)"v4");
        AssertJUnit.assertEquals((int)1, (int)this.c1.size());
        AssertJUnit.assertEquals((int)1, (int)this.c2.size());
        AssertJUnit.assertEquals((int)1, (int)this.c3.size());
        AssertJUnit.assertEquals((int)1, (int)this.c4.size());
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.remoteCache.get((Object)"k1")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.remoteCache.get((Object)"k2")));
        AssertJUnit.assertEquals((String)"v3", (String)((String)this.remoteCache.get((Object)"k3")));
        AssertJUnit.assertEquals((String)"v4", (String)((String)this.remoteCache.get((Object)"k4")));
        this.remoteCache.put((Object)"k5", (Object)"v2");
        this.remoteCache.put((Object)"k6", (Object)"v3");
        this.remoteCache.put((Object)"k7", (Object)"v1");
        this.remoteCache.put((Object)"k8", (Object)"v2");
        this.remoteCache.put((Object)"k9", (Object)"v3");
        this.remoteCache.put((Object)"k10", (Object)"v3");
        this.remoteCache.put((Object)"k11", (Object)"v3");
        this.remoteCache.put((Object)"k12", (Object)"v3");
        AssertJUnit.assertEquals((int)3, (int)this.c1.size());
        AssertJUnit.assertEquals((int)3, (int)this.c2.size());
        AssertJUnit.assertEquals((int)3, (int)this.c3.size());
        AssertJUnit.assertEquals((int)3, (int)this.c4.size());
    }

    @Test(dependsOnMethods={"testAddNewHotrodServer"})
    public void testStopServer() {
        block2: {
            this.remoteCache.put((Object)"k1", (Object)"v1");
            this.remoteCache.put((Object)"k2", (Object)"v2");
            this.remoteCache.put((Object)"k3", (Object)"v3");
            this.remoteCache.put((Object)"k4", (Object)"v4");
            AssertJUnit.assertEquals((int)1, (int)this.c1.size());
            AssertJUnit.assertEquals((int)1, (int)this.c2.size());
            AssertJUnit.assertEquals((int)1, (int)this.c3.size());
            AssertJUnit.assertEquals((int)1, (int)this.c4.size());
            AssertJUnit.assertEquals((String)"v1", (String)((String)this.remoteCache.get((Object)"k1")));
            AssertJUnit.assertEquals((String)"v2", (String)((String)this.remoteCache.get((Object)"k2")));
            AssertJUnit.assertEquals((String)"v3", (String)((String)this.remoteCache.get((Object)"k3")));
            AssertJUnit.assertEquals((String)"v4", (String)((String)this.remoteCache.get((Object)"k4")));
            this.hotRodServer4.stop();
            try {
                this.remoteCache.put((Object)"k5", (Object)"v1");
                this.remoteCache.put((Object)"k6", (Object)"v2");
                this.remoteCache.put((Object)"k7", (Object)"v3");
                this.remoteCache.put((Object)"k8", (Object)"v4");
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"exception should not happen even if the balancer redirects to failed node at the beggining");
            }
        }
    }

    @Test(dependsOnMethods={"testStopServer"})
    public void testRemoveServers() {
        ArrayList<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>();
        serverAddresses.add(new InetSocketAddress("localhost", this.hotRodServer1.getPort()));
        serverAddresses.add(new InetSocketAddress("localhost", this.hotRodServer2.getPort()));
        RoundRobinBalancingStrategy balancer = this.getBalancer();
        balancer.setServers(serverAddresses);
        this.remoteCache.put((Object)"k1", (Object)"v1");
        this.remoteCache.put((Object)"k2", (Object)"v2");
        this.remoteCache.put((Object)"k3", (Object)"v3");
        this.remoteCache.put((Object)"k4", (Object)"v4");
        AssertJUnit.assertEquals((int)2, (int)this.c1.size());
        AssertJUnit.assertEquals((int)2, (int)this.c2.size());
        AssertJUnit.assertEquals((int)0, (int)this.c3.size());
        AssertJUnit.assertEquals((int)0, (int)this.c4.size());
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.remoteCache.get((Object)"k1")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.remoteCache.get((Object)"k2")));
        AssertJUnit.assertEquals((String)"v3", (String)((String)this.remoteCache.get((Object)"k3")));
        AssertJUnit.assertEquals((String)"v4", (String)((String)this.remoteCache.get((Object)"k4")));
        this.remoteCache.put((Object)"k5", (Object)"v2");
        this.remoteCache.put((Object)"k6", (Object)"v3");
        this.remoteCache.put((Object)"k7", (Object)"v1");
        this.remoteCache.put((Object)"k8", (Object)"v2");
        this.remoteCache.put((Object)"k9", (Object)"v3");
        this.remoteCache.put((Object)"k10", (Object)"v3");
        this.remoteCache.put((Object)"k11", (Object)"v3");
        this.remoteCache.put((Object)"k12", (Object)"v3");
        AssertJUnit.assertEquals((int)6, (int)this.c1.size());
        AssertJUnit.assertEquals((int)6, (int)this.c2.size());
        AssertJUnit.assertEquals((int)0, (int)this.c3.size());
        AssertJUnit.assertEquals((int)0, (int)this.c4.size());
    }

    private RoundRobinBalancingStrategy getBalancer() {
        TcpTransportFactory transportFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCache.getRemoteCacheManager(), (String)"transportFactory");
        return (RoundRobinBalancingStrategy)TestingUtil.extractField((Object)transportFactory, (String)"balancer");
    }
}

