/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.BulkGetSimpleTest", groups={"functional"})
public class BulkGetSimpleTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = TestHelper.startHotRodServer(this.cacheManager);
        Properties hotrodClientConf = new Properties();
        hotrodClientConf.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer.getPort());
        this.remoteCacheManager = new RemoteCacheManager(hotrodClientConf);
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    @AfterTest(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    private void populateCacheManager() {
        for (int i = 0; i < 100; ++i) {
            this.remoteCache.put((Object)i, (Object)i);
        }
    }

    public void testBulkGet() {
        this.populateCacheManager();
        Map map = this.remoteCache.getBulk();
        assert (map.size() == 100);
        for (int i = 0; i < 100; ++i) {
            assert (map.get(i).equals(i));
        }
    }

    public void testBulkGetWithSize() {
        this.populateCacheManager();
        Map map = this.remoteCache.getBulk(50);
        AssertJUnit.assertEquals((int)50, (int)map.size());
        for (int i = 0; i < 100; ++i) {
            if (!map.containsKey(i)) continue;
            Integer value = (Integer)map.get(i);
            AssertJUnit.assertEquals((Object)i, (Object)value);
        }
    }

    public void testBulkGetAfterLifespanExpire() throws InterruptedException {
        HashMap<String, String> dataIn = new HashMap<String, String>();
        dataIn.put("aKey", "aValue");
        dataIn.put("bKey", "bValue");
        long startTime = System.currentTimeMillis();
        long lifespan = 10000L;
        this.remoteCache.putAll(dataIn, 10000L, TimeUnit.MILLISECONDS);
        Map dataOut = new HashMap();
        while (true) {
            dataOut = this.remoteCache.getBulk();
            if (System.currentTimeMillis() >= startTime + 10000L) break;
            AssertJUnit.assertEquals(dataIn, dataOut);
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 10000L + 30000L) {
            dataOut = this.remoteCache.getBulk();
            if (dataOut.size() != 0) continue;
            return;
        }
        assert (dataOut.size() == 0) : String.format("Data not empty, it contains: %s elements", dataOut.size());
    }
}

