/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.CacheContainerTest")
public class CacheContainerTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "someName";
    EmbeddedCacheManager cacheManager = null;
    HotRodServer hotrodServer = null;
    RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        this.cacheManager.defineConfiguration(CACHE_NAME, new ConfigurationBuilder().build());
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.remoteCacheManager = new RemoteCacheManager("localhost:" + this.hotrodServer.getPort(), true);
        return this.cacheManager;
    }

    @AfterTest(alwaysRun=true)
    public void release() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testObtainingSameInstanceMultipleTimes() {
        RemoteCache objectCache = this.remoteCacheManager.getCache();
        RemoteCache objectCache2 = this.remoteCacheManager.getCache();
        assert (objectCache == objectCache2);
    }

    public void testObtainingSameInstanceMultipleTimes2() {
        RemoteCache objectCache = this.remoteCacheManager.getCache(CACHE_NAME);
        RemoteCache objectCache2 = this.remoteCacheManager.getCache(CACHE_NAME);
        assert (objectCache == objectCache2);
    }
}

