/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.WorkerThread;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ClientConnectionPoolingTest", groups={"functional"})
public class ClientConnectionPoolingTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(ClientConnectionPoolingTest.class);
    Cache c1;
    Cache c2;
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    RemoteCache<String, String> remoteCache;
    private RemoteCacheManager remoteCacheManager;
    private GenericKeyedObjectPool connectionPool;
    private InetSocketAddress hrServ1Addr;
    private InetSocketAddress hrServ2Addr;
    private WorkerThread workerThread1;
    private WorkerThread workerThread2;
    private WorkerThread workerThread3;
    private WorkerThread workerThread4;
    private WorkerThread workerThread5;
    private WorkerThread workerThread6;

    protected void assertSupportedConfig() {
    }

    protected void createCacheManagers() throws Throwable {
        this.c1 = TestCacheManagerFactory.createLocalCacheManager((boolean)false).getCache();
        this.c2 = TestCacheManagerFactory.createLocalCacheManager((boolean)false).getCache();
        this.registerCacheManager(new CacheContainer[]{this.c1.getCacheManager(), this.c2.getCacheManager()});
        this.hotRodServer1 = TestHelper.startHotRodServer(this.c1.getCacheManager());
        this.hotRodServer2 = TestHelper.startHotRodServer(this.c2.getCacheManager());
        String servers = TestHelper.getServersString(this.hotRodServer1, this.hotRodServer2);
        Properties hotrodClientConf = new Properties();
        hotrodClientConf.put("infinispan.client.hotrod.server_list", servers);
        hotrodClientConf.put("maxActive", (Object)2);
        hotrodClientConf.put("maxTotal", (Object)8);
        hotrodClientConf.put("maxIdle", (Object)6);
        hotrodClientConf.put("whenExhaustedAction", (Object)1);
        hotrodClientConf.put("testOnBorrow", "false");
        hotrodClientConf.put("testOnReturn", "false");
        hotrodClientConf.put("timeBetweenEvictionRunsMillis", "-2");
        hotrodClientConf.put("minEvictableIdleTimeMillis", "7");
        hotrodClientConf.put("testWhileIdle", "true");
        hotrodClientConf.put("minIdle", "-5");
        hotrodClientConf.put("lifo", "true");
        hotrodClientConf.put("infinispan.client.hotrod.ping_on_startup", "false");
        this.remoteCacheManager = new RemoteCacheManager(hotrodClientConf);
        this.remoteCache = this.remoteCacheManager.getCache();
        TcpTransportFactory tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transportFactory");
        this.connectionPool = (GenericKeyedObjectPool)TestingUtil.extractField((Object)tcpConnectionFactory, (String)"connectionPool");
        this.workerThread1 = new WorkerThread(this.remoteCache);
        this.workerThread2 = new WorkerThread(this.remoteCache);
        this.workerThread3 = new WorkerThread(this.remoteCache);
        this.workerThread4 = new WorkerThread(this.remoteCache);
        this.workerThread5 = new WorkerThread(this.remoteCache);
        this.workerThread6 = new WorkerThread(this.remoteCache);
        this.hrServ1Addr = new InetSocketAddress("localhost", this.hotRodServer1.getPort());
        this.hrServ2Addr = new InetSocketAddress("localhost", this.hotRodServer2.getPort());
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws ExecutionException, InterruptedException {
        HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2);
        this.workerThread1.stop();
        this.workerThread2.stop();
        this.workerThread3.stop();
        this.workerThread4.stop();
        this.workerThread5.stop();
        this.workerThread6.stop();
        this.workerThread1.awaitTermination();
        this.workerThread2.awaitTermination();
        this.workerThread3.awaitTermination();
        this.workerThread4.awaitTermination();
        this.workerThread5.awaitTermination();
        this.workerThread6.awaitTermination();
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
    }

    @Test
    public void testPropsCorrectlySet() {
        AssertJUnit.assertEquals((int)2, (int)this.connectionPool.getMaxActive());
        AssertJUnit.assertEquals((int)8, (int)this.connectionPool.getMaxTotal());
        AssertJUnit.assertEquals((int)6, (int)this.connectionPool.getMaxIdle());
        AssertJUnit.assertEquals((int)1, (int)this.connectionPool.getWhenExhaustedAction());
        AssertJUnit.assertEquals((boolean)false, (boolean)this.connectionPool.getTestOnBorrow());
        AssertJUnit.assertEquals((boolean)false, (boolean)this.connectionPool.getTestOnReturn());
        AssertJUnit.assertEquals((long)-2L, (long)this.connectionPool.getTimeBetweenEvictionRunsMillis());
        AssertJUnit.assertEquals((long)7L, (long)this.connectionPool.getMinEvictableIdleTimeMillis());
        AssertJUnit.assertEquals((boolean)true, (boolean)this.connectionPool.getTestWhileIdle());
        AssertJUnit.assertEquals((int)-5, (int)this.connectionPool.getMinIdle());
        AssertJUnit.assertEquals((boolean)true, (boolean)this.connectionPool.getLifo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMaxActiveReached() throws Exception {
        this.workerThread1.put("k1", "v1");
        this.workerThread1.put("k2", "v2");
        AssertJUnit.assertEquals((int)1, (int)this.c1.size());
        AssertJUnit.assertEquals((int)1, (int)this.c2.size());
        AssertJUnit.assertEquals((String)"v1", (String)((String)this.remoteCache.get((Object)"k1")));
        AssertJUnit.assertEquals((int)1, (int)this.c1.size());
        AssertJUnit.assertEquals((String)"v2", (String)((String)this.remoteCache.get((Object)"k2")));
        AssertJUnit.assertEquals((int)1, (int)this.c2.size());
        AssertJUnit.assertEquals((int)0, (int)this.connectionPool.getNumActive((Object)this.hrServ1Addr));
        AssertJUnit.assertEquals((int)0, (int)this.connectionPool.getNumActive((Object)this.hrServ2Addr));
        AssertJUnit.assertEquals((int)1, (int)this.connectionPool.getNumIdle((Object)this.hrServ1Addr));
        AssertJUnit.assertEquals((int)1, (int)this.connectionPool.getNumIdle((Object)this.hrServ2Addr));
        DelayTransportInterceptor dt1 = new DelayTransportInterceptor(true);
        DelayTransportInterceptor dt2 = new DelayTransportInterceptor(true);
        this.c1.getAdvancedCache().addInterceptor((CommandInterceptor)dt1, 0);
        this.c2.getAdvancedCache().addInterceptor((CommandInterceptor)dt2, 0);
        log.info((Object)"Cache operations blocked");
        try {
            this.workerThread1.putAsync("k3", "v3");
            this.workerThread2.putAsync("k4", "v4");
            log.info((Object)"Async calls for k3 and k4 is done.");
            this.eventually(new AbstractInfinispanTest.Condition(){

                public boolean isSatisfied() throws Exception {
                    return 1 == ClientConnectionPoolingTest.this.connectionPool.getNumActive((Object)ClientConnectionPoolingTest.this.hrServ1Addr) && 1 == ClientConnectionPoolingTest.this.connectionPool.getNumActive((Object)ClientConnectionPoolingTest.this.hrServ2Addr) && 0 == ClientConnectionPoolingTest.this.connectionPool.getNumIdle((Object)ClientConnectionPoolingTest.this.hrServ1Addr) && 0 == ClientConnectionPoolingTest.this.connectionPool.getNumIdle((Object)ClientConnectionPoolingTest.this.hrServ2Addr);
                }
            });
            this.workerThread3.putAsync("k5", "v5");
            this.workerThread4.putAsync("k6", "v6");
            this.eventually(new AbstractInfinispanTest.Condition(){

                public boolean isSatisfied() throws Exception {
                    return 2 == ClientConnectionPoolingTest.this.connectionPool.getNumActive((Object)ClientConnectionPoolingTest.this.hrServ1Addr) && 2 == ClientConnectionPoolingTest.this.connectionPool.getNumActive((Object)ClientConnectionPoolingTest.this.hrServ2Addr) && 0 == ClientConnectionPoolingTest.this.connectionPool.getNumIdle((Object)ClientConnectionPoolingTest.this.hrServ1Addr) && 0 == ClientConnectionPoolingTest.this.connectionPool.getNumIdle((Object)ClientConnectionPoolingTest.this.hrServ2Addr);
                }
            });
            this.workerThread5.putAsync("k7", "v7");
            this.workerThread6.putAsync("k8", "v8");
            Thread.sleep(2000L);
            AssertJUnit.assertEquals((int)2, (int)this.connectionPool.getNumActive((Object)this.hrServ1Addr));
            AssertJUnit.assertEquals((int)2, (int)this.connectionPool.getNumActive((Object)this.hrServ2Addr));
            AssertJUnit.assertEquals((int)0, (int)this.connectionPool.getNumIdle((Object)this.hrServ1Addr));
            AssertJUnit.assertEquals((int)0, (int)this.connectionPool.getNumIdle((Object)this.hrServ2Addr));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        finally {
            dt1.allow();
            dt2.allow();
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                return ClientConnectionPoolingTest.this.connectionPool.getNumActive() == 0;
            }
        }, 1000L);
        this.assertExistKeyValue("k3", "v3");
        this.assertExistKeyValue("k4", "v4");
        this.assertExistKeyValue("k5", "v5");
        this.assertExistKeyValue("k6", "v6");
        this.assertExistKeyValue("k7", "v7");
        this.assertExistKeyValue("k8", "v8");
        AssertJUnit.assertEquals((int)0, (int)this.connectionPool.getNumActive((Object)this.hrServ1Addr));
        AssertJUnit.assertEquals((int)0, (int)this.connectionPool.getNumActive((Object)this.hrServ2Addr));
        AssertJUnit.assertEquals((int)2, (int)this.connectionPool.getNumIdle((Object)this.hrServ1Addr));
        AssertJUnit.assertEquals((int)2, (int)this.connectionPool.getNumIdle((Object)this.hrServ2Addr));
    }

    private void assertExistKeyValue(String key, String value) throws InterruptedException {
        boolean exists = false;
        for (int i = 0; i < 10; ++i) {
            boolean bl = exists = value.equals(this.remoteCache.get((Object)key)) || value.equals(this.remoteCache.get((Object)key));
            if (exists) break;
            Thread.sleep(1000L);
        }
        AssertJUnit.assertEquals((String)("key value not found: (" + key + ", " + value + ")"), (boolean)true, (boolean)exists);
    }

    public static class DelayTransportInterceptor
    extends CommandInterceptor {
        private final ReentrantLock lock = new ReentrantLock();

        public DelayTransportInterceptor(boolean lock) {
            if (lock) {
                this.block();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            log.trace((Object)("Acquiring lock. " + this.lockInfo()));
            this.lock.lock();
            try {
                Object object = super.handleDefault(ctx, command);
                return object;
            }
            finally {
                log.trace((Object)("Done operation, releasing lock" + this.lockInfo()));
                this.lock.unlock();
            }
        }

        private String lockInfo() {
            return " Is locked? " + this.lock.isLocked() + ". Lock held by me? " + this.lock.isHeldByCurrentThread();
        }

        public void block() {
            log.trace((Object)("block. " + this.lockInfo()));
            this.lock.lock();
        }

        public void allow() {
            log.trace((Object)("allow." + this.lockInfo()));
            this.lock.unlock();
        }
    }
}

