/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyAffinityServiceFactory;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.retry.DistributionRetryTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.Util;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ConsistentHashV1IntegrationTest")
public class ConsistentHashV1IntegrationTest
extends MultipleCacheManagersTest {
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    private HotRodServer hotRodServer3;
    private HotRodServer hotRodServer4;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCacheImpl remoteCache;
    private KeyAffinityService kas;
    private ExecutorService ex;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = this.buildConfiguration();
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.hotRodServer1 = TestHelper.startHotRodServer(this.manager(0));
        this.hotRodServer2 = TestHelper.startHotRodServer(this.manager(1));
        this.hotRodServer3 = TestHelper.startHotRodServer(this.manager(2));
        this.hotRodServer4 = TestHelper.startHotRodServer(this.manager(3));
        this.waitForClusterToForm();
        Properties clientConfig = new Properties();
        clientConfig.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer2.getPort());
        this.remoteCacheManager = new RemoteCacheManager(clientConfig);
        this.remoteCache = (RemoteCacheImpl)this.remoteCacheManager.getCache();
        assert (this.cacheManagers.size() == 4);
        this.ex = Executors.newSingleThreadExecutor();
        this.kas = KeyAffinityServiceFactory.newKeyAffinityService((Cache)this.cache(0), (Executor)this.ex, (KeyGenerator)new DistributionRetryTest.ByteKeyGenerator(), (int)2, (boolean)true);
        for (int i = 0; i < 4; ++i) {
            this.advancedCache(i).addInterceptor((CommandInterceptor)new HitsAwareCacheManagersTest.HitCountInterceptor(), 1);
        }
    }

    private ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder builder = ConsistentHashV1IntegrationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.jmxStatistics().enable();
        builder.clustering().hash().numOwners(2).stateTransfer().fetchInMemoryState(false);
        return builder;
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
    }

    @AfterTest(alwaysRun=true)
    public void cleanUp() {
        this.ex.shutdownNow();
        this.kas.stop();
        this.stopServer(this.hotRodServer1);
        this.stopServer(this.hotRodServer2);
        this.stopServer(this.hotRodServer3);
        this.stopServer(this.hotRodServer4);
        this.remoteCache.stop();
        this.remoteCacheManager.stop();
    }

    private void stopServer(HotRodServer hrs) {
        HotRodClientTestingUtil.killServers(hrs);
    }

    public void testCorrectBalancingOfKeys() {
        this.runTest(0);
        this.runTest(1);
        this.runTest(2);
        this.runTest(3);
    }

    private void runTest(int cacheIndex) {
        org.infinispan.distribution.ch.ConsistentHash serverCH = this.advancedCache(cacheIndex).getDistributionManager().getConsistentHash();
        int misses = 0;
        for (int i = 0; i < 200; ++i) {
            byte[] keyBytes = (byte[])this.kas.getKeyForAddress(this.address(cacheIndex));
            String key = DistributionRetryTest.ByteKeyGenerator.getStringObject(keyBytes);
            List serverBackups = serverCH.locateOwners((Object)keyBytes);
            assert (serverBackups.contains(this.address(cacheIndex)));
            this.remoteCache.put((Object)key, (Object)"v");
            Address hitServer = this.getHitServer();
            if (!serverBackups.contains(hitServer)) {
                ++misses;
            }
            assert (misses < 5) : String.format("i=%s, backups: %s, hit server: %s, key=%s", i, serverBackups, hitServer, Util.printArray((byte[])key.getBytes(), (boolean)false));
        }
    }

    public void testCorrectBalancingOfKeysAfterNodeKill() {
        final AtomicInteger clientTopologyId = (AtomicInteger)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"topologyId");
        final int topologyIdBeforeJoin = clientTopologyId.get();
        this.log.tracef("Starting test with client topology id %d", (Object)topologyIdBeforeJoin);
        EmbeddedCacheManager cm5 = this.addClusterEnabledCacheManager(this.buildConfiguration());
        HotRodServer hotRodServer5 = TestHelper.startHotRodServer(cm5);
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                ConsistentHashV1IntegrationTest.this.log.tracef("Client topology id is %d, waiting for it to become %d", (Object)clientTopologyId.get(), (Object)(topologyIdBeforeJoin + 2));
                ConsistentHashV1IntegrationTest.this.remoteCache.put((Object)"k", (Object)"v");
                return clientTopologyId.get() >= topologyIdBeforeJoin + 2;
            }
        });
        this.resetHitInterceptors();
        this.runTest(0);
        this.runTest(1);
        this.runTest(2);
        this.runTest(3);
        this.stopServer(hotRodServer5);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm5});
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                ConsistentHashV1IntegrationTest.this.log.tracef("Client topology id is %d, waiting for it to become %d", (Object)clientTopologyId.get(), (Object)(topologyIdBeforeJoin + 4));
                ConsistentHashV1IntegrationTest.this.remoteCache.put((Object)"k", (Object)"v");
                return clientTopologyId.get() >= topologyIdBeforeJoin + 4;
            }
        });
        this.resetHitInterceptors();
        this.runTest(0);
        this.runTest(1);
        this.runTest(2);
        this.runTest(3);
    }

    private ConsistentHash extractClientConsistentHash() {
        TcpTransportFactory transport = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transport");
        return transport.getConsistentHash();
    }

    private Address getHitServer() {
        ArrayList<Address> result = new ArrayList<Address>();
        for (int i = 0; i < 4; ++i) {
            InterceptorChain ic = (InterceptorChain)this.advancedCache(i).getComponentRegistry().getComponent(InterceptorChain.class);
            HitsAwareCacheManagersTest.HitCountInterceptor interceptor = (HitsAwareCacheManagersTest.HitCountInterceptor)((Object)ic.getInterceptorsWithClass(HitsAwareCacheManagersTest.HitCountInterceptor.class).get(0));
            if (interceptor.getHits() == 1) {
                result.add(this.address(i));
            }
            interceptor.reset();
        }
        if (result.size() > 1) {
            throw new IllegalStateException("More than one hit! : " + result);
        }
        return (Address)result.get(0);
    }

    private void resetHitInterceptors() {
        for (int i = 0; i < 4; ++i) {
            InterceptorChain ic = (InterceptorChain)this.advancedCache(i).getComponentRegistry().getComponent(InterceptorChain.class);
            HitsAwareCacheManagersTest.HitCountInterceptor interceptor = (HitsAwareCacheManagersTest.HitCountInterceptor)((Object)ic.getInterceptorsWithClass(HitsAwareCacheManagersTest.HitCountInterceptor.class).get(0));
            interceptor.reset();
        }
    }
}

