/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.jboss.JBossMarshaller;
import org.infinispan.server.core.CacheValue;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.ByteArrayKey;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.DefaultExpirationTest", groups={"functional"})
public class DefaultExpirationTest
extends SingleCacheManagerTest {
    private Marshaller marshaller = new JBossMarshaller();
    private RemoteCache<String, String> remoteCache;
    private RemoteCacheManager remoteCacheManager;
    private Cache<ByteArrayKey, CacheValue> cache;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        builder.expiration().lifespan(3L, TimeUnit.SECONDS).maxIdle(2L, TimeUnit.SECONDS);
        this.cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
        this.cache = this.cacheManager.getCache();
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        Properties config = new Properties();
        config.put("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.hotrodServer.getPort());
        return new RemoteCacheManager(config);
    }

    @AfterClass(alwaysRun=true)
    public void testDestroyRemoteCacheFactory() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    @Test
    public void testDefaultExpiration() throws Exception {
        this.remoteCache.put((Object)"Key", (Object)"Value");
        InternalCacheEntry entry = this.getInternalCacheEntry(this.cache, "Key", "Value");
        AssertJUnit.assertTrue((boolean)entry.canExpire());
        AssertJUnit.assertEquals((long)3000L, (long)entry.getLifespan());
        AssertJUnit.assertEquals((long)2000L, (long)entry.getMaxIdle());
        Thread.sleep(5000L);
        AssertJUnit.assertFalse((boolean)this.remoteCache.containsKey((Object)"Key"));
    }

    private InternalCacheEntry getInternalCacheEntry(Cache<ByteArrayKey, CacheValue> cache, String key, String value) throws Exception {
        InternalCacheEntry entry = cache.getAdvancedCache().getDataContainer().get((Object)this.toBinaryKey(key));
        if (value != null) {
            CacheValue v = (CacheValue)entry.getValue();
            AssertJUnit.assertEquals((byte[])this.toBinaryValue(value), (byte[])v.data());
        }
        return entry;
    }

    private ByteArrayKey toBinaryKey(String key) throws Exception {
        byte[] keyBytes = this.marshaller.objectToByteBuffer((Object)key, 64);
        return new ByteArrayKey(keyBytes);
    }

    private byte[] toBinaryValue(String value) throws Exception {
        return this.marshaller.objectToByteBuffer((Object)value, 64);
    }
}

