/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ForceReturnValueTest", groups={"functional"})
public class ForceReturnValueTest
extends SingleCacheManagerTest {
    RemoteCache remoteCache;
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createLocalCacheManager((boolean)false);
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.remoteCacheManager = new RemoteCacheManager("localhost", this.hotrodServer.getPort());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        super.teardown();
    }

    public void testPut() {
        assert (null == this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        assert ("aValue".equals(this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"aKey", (Object)"otherValue")));
        assert (this.remoteCache.containsKey((Object)"aKey"));
        assert (this.remoteCache.get((Object)"aKey").equals("otherValue"));
    }

    public void testRemove() {
        assert (null == this.remoteCache.put((Object)"aKey", (Object)"aValue"));
        assert (this.remoteCache.get((Object)"aKey").equals("aValue"));
        assert ("aValue".equals(this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)"aKey")));
        assert (!this.remoteCache.containsKey((Object)"aKey"));
    }

    public void testRemoveNonExistForceReturnPrevious() {
        AssertJUnit.assertNull((Object)this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)"aKey"));
        this.remoteCache.put((Object)"k", (Object)"v");
    }

    public void testContains() {
        assert (!this.remoteCache.containsKey((Object)"aKey"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (this.remoteCache.containsKey((Object)"aKey"));
    }

    public void testReplace() {
        assert (null == this.remoteCache.replace((Object)"aKey", (Object)"anotherValue"));
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert ("aValue".equals(this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).replace((Object)"aKey", (Object)"anotherValue")));
        assert (this.remoteCache.get((Object)"aKey").equals("anotherValue"));
    }

    public void testPutIfAbsent() {
        this.remoteCache.put((Object)"aKey", (Object)"aValue");
        assert (null == this.remoteCache.putIfAbsent((Object)"aKey", (Object)"anotherValue"));
        Object existingValue = this.remoteCache.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)"aKey", (Object)"anotherValue");
        assert ("aValue".equals(existingValue)) : "Existing value was:" + existingValue;
    }
}

