/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.WorkerThread;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.HeavyLoadConnectionPoolingTest", groups={"functional"})
public class HeavyLoadConnectionPoolingTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;
    private GenericKeyedObjectPool connectionPool;

    @AfterMethod(alwaysRun=true)
    protected void clearContent() {
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createLocalCacheManager((boolean)false);
        this.cache = this.cacheManager.getCache();
        this.cache.getAdvancedCache().addInterceptor((CommandInterceptor)new ConstantDelayTransportInterceptor(100), 0);
        this.hotRodServer = TestHelper.startHotRodServer(this.cacheManager);
        Properties hotrodClientConf = new Properties();
        hotrodClientConf.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer.getPort());
        hotrodClientConf.put("timeBetweenEvictionRunsMillis", "500");
        hotrodClientConf.put("minEvictableIdleTimeMillis", "100");
        hotrodClientConf.put("numTestsPerEvictionRun", "10");
        hotrodClientConf.put("infinispan.client.hotrod.ping_on_startup", "true");
        this.remoteCacheManager = new RemoteCacheManager(hotrodClientConf);
        this.remoteCache = this.remoteCacheManager.getCache();
        TcpTransportFactory tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transportFactory");
        this.connectionPool = (GenericKeyedObjectPool)TestingUtil.extractField((Object)tcpConnectionFactory, (String)"connectionPool");
        return this.cacheManager;
    }

    @AfterClass(alwaysRun=true)
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testHeavyLoad() throws InterruptedException, ExecutionException {
        ArrayList<WorkerThread> workers = new ArrayList<WorkerThread>();
        for (int i = 0; i < 20; ++i) {
            WorkerThread workerThread = new WorkerThread(this.remoteCache);
            workers.add(workerThread);
            workerThread.stress();
        }
        while (this.connectionPool.getNumActive() <= 15) {
            Thread.sleep(10L);
        }
        for (WorkerThread wt : workers) {
            wt.stop();
        }
        for (WorkerThread wt : workers) {
            wt.awaitTermination();
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            public boolean isSatisfied() throws Exception {
                int numIdle = HeavyLoadConnectionPoolingTest.this.connectionPool.getNumIdle();
                int numActive = HeavyLoadConnectionPoolingTest.this.connectionPool.getNumActive();
                return numIdle == 0 && numActive == 0;
            }
        });
    }

    public static class ConstantDelayTransportInterceptor
    extends CommandInterceptor {
        private int millis;

        public ConstantDelayTransportInterceptor(int millis) {
            this.millis = millis;
        }

        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            Thread.sleep(this.millis);
            return super.handleDefault(ctx, command);
        }
    }
}

