/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.PingOnStartupTest")
public class PingOnStartupTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = PingOnStartupTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.createHotRodServers(2, builder);
    }

    public void testTopologyFetched() {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "localhost:" + hotRodServer2.getPort() + ";localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "true");
        props.put("timeBetweenEvictionRunsMillis", "500");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() {
                TcpTransportFactory tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.rcm, (String)"transportFactory");
                for (int i = 0; i < 10 && tcpConnectionFactory.getServers().size() == 1; ++i) {
                    TestingUtil.sleepThread((long)1000L);
                }
                AssertJUnit.assertEquals((int)2, (int)tcpConnectionFactory.getServers().size());
            }
        });
    }

    public void testTopologyNotFetched() {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "false");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() {
                TcpTransportFactory tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.rcm, (String)"transportFactory");
                AssertJUnit.assertEquals((int)1, (int)tcpConnectionFactory.getServers().size());
            }
        });
    }

    public void testGetCacheWithPingOnStartupDisabledSingleNode() {
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", "boomoo:12345");
        props.put("infinispan.client.hotrod.ping_on_startup", "false");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() {
                this.rcm.getCache();
            }
        });
    }

    public void testGetCacheWithPingOnStartupDisabledMultipleNodes() {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "boomoo:12345;localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "false");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() {
                RemoteCache cache = this.rcm.getCache();
                AssertJUnit.assertFalse((boolean)cache.containsKey((Object)"k"));
            }
        });
    }

    public void testGetCacheWorksIfNodeDown() {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "boomoo:12345;localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "true");
        props.put("timeBetweenEvictionRunsMillis", "500");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() {
                this.rcm.getCache();
            }
        });
    }

    public void testGetCacheWorksIfNodeNotDown() {
        Properties props = new Properties();
        HotRodServer hotRodServer2 = this.server(1);
        props.put("infinispan.client.hotrod.server_list", "localhost:" + hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "true");
        props.put("timeBetweenEvictionRunsMillis", "500");
        HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager(props)){

            @Override
            public void call() {
                this.rcm.getCache();
            }
        });
    }
}

