/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.URL;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.RemoteCacheManagerTest", groups={"functional"})
public class RemoteCacheManagerTest
extends SingleCacheManagerTest {
    HotRodServer hotrodServer;
    int port;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createLocalCacheManager((boolean)false);
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.port = this.hotrodServer.getPort();
    }

    @AfterTest(alwaysRun=true)
    public void release() {
        try {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
            HotRodClientTestingUtil.killServers(this.hotrodServer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testNoArgConstructor() {
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager();
        assert (remoteCacheManager.isStarted());
        remoteCacheManager.stop();
    }

    public void testBooleanConstructor() {
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(false);
        assert (!remoteCacheManager.isStarted());
        remoteCacheManager.start();
        remoteCacheManager.stop();
    }

    public void testUrlAndBooleanConstructor() throws Exception {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("empty-config.properties");
        assert (resource != null);
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(resource, false);
        assert (!remoteCacheManager.isStarted());
        remoteCacheManager.config.getProperties().setProperty("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.port);
        remoteCacheManager.start();
        this.assertWorks(remoteCacheManager);
        remoteCacheManager.stop();
    }

    public void testPropertiesConstructor() {
        Properties p = new Properties();
        p.setProperty("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.port);
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(p);
        assert (remoteCacheManager.isStarted());
        this.assertWorks(remoteCacheManager);
        remoteCacheManager.stop();
    }

    public void testPropertiesAndBooleanConstructor() {
        Properties p = new Properties();
        p.setProperty("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.port);
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(p, false);
        assert (!remoteCacheManager.isStarted());
        remoteCacheManager.start();
        this.assertWorks(remoteCacheManager);
        remoteCacheManager.stop();
    }

    public void testStringAndBooleanConstructor() {
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager("localhost:" + this.hotrodServer.getPort(), false);
        assert (!remoteCacheManager.isStarted());
        remoteCacheManager.start();
        this.assertWorks(remoteCacheManager);
        remoteCacheManager.stop();
    }

    public void testGetUndefinedCache() {
        Properties p = new Properties();
        p.setProperty("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.port);
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(p, false);
        assert (!remoteCacheManager.isStarted());
        remoteCacheManager.start();
        assert (null == remoteCacheManager.getCache("Undefined1234"));
        remoteCacheManager.stop();
    }

    private void assertWorks(RemoteCacheManager remoteCacheManager) {
        RemoteCache cache = remoteCacheManager.getCache();
        cache.put((Object)"aKey", (Object)"aValue");
        assert (cache.get((Object)"aKey").equals("aValue"));
    }
}

