/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Properties;
import org.infinispan.client.hotrod.HotRodIntegrationTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ServerRestartTest", groups={"functional"})
public class ServerRestartTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(HotRodIntegrationTest.class);
    private RemoteCache defaultRemote;
    private RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createLocalCacheManager((boolean)false);
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        Properties config = new Properties();
        config.put("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.hotrodServer.getPort());
        config.put("timeBetweenEvictionRunsMillis", "2000");
        this.remoteCacheManager = new RemoteCacheManager(config);
        this.defaultRemote = this.remoteCacheManager.getCache();
    }

    @AfterClass(alwaysRun=true)
    public void testDestroyRemoteCacheFactory() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testServerShutdown() throws Exception {
        this.defaultRemote.put((Object)"k", (Object)"v");
        assert (this.defaultRemote.get((Object)"k").equals("v"));
        int port = this.hotrodServer.getPort();
        this.hotrodServer.stop();
        Properties properties = new Properties();
        properties.setProperty("infinispan.server.host", "localhost");
        properties.setProperty("infinispan.server.port", Integer.toString(port));
        properties.setProperty("infinispan.server.master_threads", "2");
        properties.setProperty("infinispan.server.worker_threads", "2");
        properties.setProperty("infinispan.server.idle_timeout", "20000");
        properties.setProperty("infinispan.server.tcp_no_delay", "true");
        properties.setProperty("infinispan.server.send_buf_size", "15000");
        properties.setProperty("infinispan.server.recv_buf_size", "25000");
        this.hotrodServer.start(properties, this.cacheManager);
        Thread.sleep(3000L);
        assert (this.defaultRemote.get((Object)"k").equals("v"));
        this.defaultRemote.put((Object)"k", (Object)"v");
    }
}

