/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import junit.framework.Assert;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ServerShutdownTest", groups={"functional"})
public class ServerShutdownTest {
    public void testServerShutdownWithConnectedClient() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                HotRodServer hotrodServer = TestHelper.startHotRodServer(this.cm);
                try {
                    HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager("localhost", hotrodServer.getPort())){

                        @Override
                        public void call() {
                            RemoteCache remoteCache = this.rcm.getCache();
                            remoteCache.put((Object)"k", (Object)"v");
                            Assert.assertEquals((Object)"v", (Object)remoteCache.get((Object)"k"));
                        }
                    });
                }
                catch (Throwable throwable) {
                    HotRodClientTestingUtil.killServers(hotrodServer);
                    throw throwable;
                }
                HotRodClientTestingUtil.killServers(hotrodServer);
            }
        });
    }

    public void testServerShutdownWithoutConnectedClient() {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createLocalCacheManager((boolean)false)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                HotRodServer hotrodServer = TestHelper.startHotRodServer(this.cm);
                try {
                    HotRodClientTestingUtil.withRemoteCacheManager(new RemoteCacheManagerCallable(new RemoteCacheManager("localhost", hotrodServer.getPort())){

                        @Override
                        public void call() {
                            RemoteCache remoteCache = this.rcm.getCache();
                            remoteCache.put((Object)"k", (Object)"v");
                            Assert.assertEquals((Object)"v", (Object)remoteCache.get((Object)"k"));
                        }
                    });
                }
                catch (Throwable throwable) {
                    HotRodClientTestingUtil.killServers(hotrodServer);
                    throw throwable;
                }
                HotRodClientTestingUtil.killServers(hotrodServer);
            }
        });
    }
}

