/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.util.Properties;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;

public abstract class AbstractRetryTest
extends HitsAwareCacheManagersTest {
    protected HotRodServer hotRodServer1;
    protected HotRodServer hotRodServer2;
    protected HotRodServer hotRodServer3;
    RemoteCacheImpl remoteCache;
    protected RemoteCacheManager remoteCacheManager;
    protected TcpTransportFactory tcpConnectionFactory;
    protected ConfigurationBuilder config;
    protected RoundRobinBalancingStrategy strategy;

    public AbstractRetryTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void assertSupportedConfig() {
    }

    protected void createCacheManagers() throws Throwable {
        assert (this.cleanupAfterMethod());
        this.config = this.getCacheConfig();
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.config);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.config);
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.config);
        this.registerCacheManager(new CacheContainer[]{cm1});
        this.registerCacheManager(new CacheContainer[]{cm2});
        this.registerCacheManager(new CacheContainer[]{cm3});
        this.hotRodServer1 = TestHelper.startHotRodServer(this.manager(0));
        this.hrServ2CacheManager.put(this.getAddress(this.hotRodServer1), cm1);
        this.hotRodServer2 = TestHelper.startHotRodServer(this.manager(1));
        this.hrServ2CacheManager.put(this.getAddress(this.hotRodServer2), cm2);
        this.hotRodServer3 = TestHelper.startHotRodServer(this.manager(2));
        this.hrServ2CacheManager.put(this.getAddress(this.hotRodServer3), cm3);
        this.waitForClusterToForm();
        Properties clientConfig = new Properties();
        clientConfig.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer2.getPort());
        clientConfig.put("infinispan.client.hotrod.force_return_values", "true");
        clientConfig.put("infinispan.client.hotrod.connect_timeout", "5");
        clientConfig.put("maxActive", (Object)1);
        this.remoteCacheManager = new RemoteCacheManager(clientConfig);
        this.remoteCache = (RemoteCacheImpl)this.remoteCacheManager.getCache();
        this.tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transportFactory");
        this.strategy = (RoundRobinBalancingStrategy)this.tcpConnectionFactory.getBalancer();
        this.addInterceptors();
        assert (this.cacheManagers.size() == 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        try {
            if (this.remoteCache != null) {
                this.remoteCache.stop();
            }
        }
        finally {
            try {
                if (this.remoteCacheManager != null) {
                    this.remoteCacheManager.stop();
                }
            }
            finally {
                try {
                    if (this.hotRodServer1 != null) {
                        this.hotRodServer1.stop();
                    }
                }
                finally {
                    try {
                        if (this.hotRodServer2 != null) {
                            this.hotRodServer2.stop();
                        }
                    }
                    finally {
                        try {
                            if (this.hotRodServer3 != null) {
                                this.hotRodServer3.stop();
                            }
                        }
                        finally {
                            super.clearContent();
                        }
                    }
                }
            }
        }
    }

    protected abstract ConfigurationBuilder getCacheConfig();
}

