/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.AfterClass;

public abstract class BaseBulkGetKeysTest
extends MultipleCacheManagersTest {
    protected HotRodServer[] hotrodServers;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;

    protected abstract int numberOfHotRodServers();

    protected abstract ConfigurationBuilder clusterConfig();

    protected void createCacheManagers() throws Throwable {
        int numServers = this.numberOfHotRodServers();
        this.hotrodServers = new HotRodServer[numServers];
        this.createCluster(this.clusterConfig(), this.numberOfHotRodServers());
        for (int i = 0; i < numServers; ++i) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(i);
            this.hotrodServers[i] = TestHelper.startHotRodServer(cm);
        }
        String servers = TestHelper.getServersString(this.hotrodServers);
        this.remoteCacheManager = new RemoteCacheManager(servers);
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    @AfterClass
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServers);
    }

    protected void populateCacheManager() {
        for (int i = 0; i < 100; ++i) {
            this.remoteCache.put((Object)i, (Object)i);
        }
    }

    public void testBulkGetKeys() {
        this.populateCacheManager();
        Set set = this.remoteCache.keySet();
        assert (set.size() == 100);
        for (int i = 0; i < 100; ++i) {
            assert (set.contains(i));
        }
    }

    public void testBulkGetAfterLifespanExpire() throws InterruptedException {
        HashMap<String, String> dataIn = new HashMap<String, String>();
        dataIn.put("aKey", "aValue");
        dataIn.put("bKey", "bValue");
        long startTime = System.currentTimeMillis();
        long lifespan = 10000L;
        this.remoteCache.putAll(dataIn, 10000L, TimeUnit.MILLISECONDS);
        Set dataOut = new HashSet();
        while (true) {
            dataOut = this.remoteCache.keySet();
            if (System.currentTimeMillis() >= startTime + 10000L) break;
            assert (dataOut.size() == dataIn.size()) : String.format("Data size not the same, put in %s elements, keySet has %s elements", dataIn.size(), dataOut.size());
            for (Object outKey : dataOut) {
                assert (dataIn.containsKey(outKey));
            }
            Thread.sleep(100L);
        }
        while (System.currentTimeMillis() < startTime + 10000L + 30000L) {
            dataOut = this.remoteCache.keySet();
            if (dataOut.size() != 0) continue;
            return;
        }
        assert (dataOut.size() == 0) : String.format("Data not empty, it contains: %s elements", dataOut.size());
    }
}

