/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.SocketTimeoutException;
import javax.net.ssl.SSLException;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.SslTest", groups={"functional"})
public class SslTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(SslTest.class);
    RemoteCache<String, String> defaultRemote;
    private RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.getCache();
        return this.cacheManager;
    }

    private void initServerAndClient(boolean sslServer, boolean sslClient) {
        this.hotrodServer = new HotRodServer();
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        String keyStoreFileName = tccl.getResource("keystore.jks").getPath();
        String trustStoreFileName = tccl.getResource("truststore.jks").getPath();
        serverBuilder.ssl().enabled(sslServer).keyStoreFileName(keyStoreFileName).keyStorePassword("secret".toCharArray()).trustStoreFileName(trustStoreFileName).trustStorePassword("secret".toCharArray());
        this.hotrodServer.start(serverBuilder.build(), this.cacheManager);
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort()).socketTimeout(3000).connectionPool().maxActive(1).ssl().enabled(sslClient).keyStoreFileName(keyStoreFileName).keyStorePassword("secret".toCharArray()).trustStoreFileName(trustStoreFileName).trustStorePassword("secret".toCharArray()).connectionPool().timeBetweenEvictionRuns(2000L);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.defaultRemote = this.remoteCacheManager.getCache();
    }

    @AfterMethod
    public void testDestroyRemoteCacheFactory() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testSSLServerSSLClient() throws Exception {
        this.initServerAndClient(true, true);
        this.defaultRemote.put((Object)"k", (Object)"v");
        assert (((String)this.defaultRemote.get((Object)"k")).equals("v"));
    }

    public void testSSLServerPlainClient() throws Exception {
        try {
            this.initServerAndClient(true, false);
            AssertJUnit.fail((String)"Expecting a SocketTimeoutException");
        }
        catch (TransportException e) {
            AssertJUnit.assertTrue((boolean)(e.getCause() instanceof SocketTimeoutException));
        }
    }

    public void testPlainServerSSLClient() throws Exception {
        try {
            this.initServerAndClient(false, true);
            AssertJUnit.fail((String)"Expecting a SSLException");
        }
        catch (TransportException e) {
            AssertJUnit.assertTrue((boolean)(e.getCause() instanceof SSLException));
        }
    }
}

