/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.infinispan.client.hotrod.marshall.ApacheAvroMarshaller;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.marshall.ApacheAvroMarshallerTest")
public class ApacheAvroMarshallerTest {
    private final ApacheAvroMarshaller marshaller = new ApacheAvroMarshaller();

    public void testStringMarshalling() {
        String x = "Galder";
        String y = (String)this.marshallUnmarshall(x);
        assert (y.equals(x));
    }

    public void testBooleanMarshalling() {
        boolean x = true;
        boolean y = (Boolean)this.marshallUnmarshall(x);
        assert (x == y);
        this.assertEquality(new Boolean(false));
    }

    public void testIntegerMarshalling() {
        int x = 99;
        int y = (Integer)this.marshallUnmarshall(x);
        assert (x == y);
        this.assertEquality(new Integer(12345));
    }

    public void testLongMarshalling() {
        long x = Long.MAX_VALUE;
        long y = (Long)this.marshallUnmarshall(x);
        assert (x == y);
        this.assertEquality(new Long(0x100000000000000L));
    }

    public void testFloatMarshalling() {
        float x = 123.4f;
        float y = ((Float)this.marshallUnmarshall(Float.valueOf(x))).floatValue();
        assert (x == y);
        this.assertEquality(new Float(56789.9));
    }

    public void testDoubleMarshalling() {
        double x = 123.4;
        double y = (Double)this.marshallUnmarshall(x);
        assert (x == y);
        this.assertEquality(new Double(5.678E9));
    }

    public void testNullMarshalling() {
        assert (null == this.marshallUnmarshall(null));
    }

    public void testBytesMarshalling() {
        byte[] x = new byte[]{1, 2, 3, 4};
        byte[] y = (byte[])this.marshallUnmarshall(x);
        assert (Arrays.equals(x, y));
    }

    public void testStringArrayMarshalling() {
        this.assertArrayEquality(new String[]{"Basque Country", "Spain", "UK", "Switzerland"});
    }

    public void testIntArrayMarshalling() {
        this.assertArrayEquality(new Integer[]{1234, 5678, 9101112});
    }

    public void testLongArrayMarshalling() {
        this.assertArrayEquality(new Long[]{Long.MAX_VALUE, 0x100000000000000L});
    }

    public void testBooleanArrayMarshalling() {
        this.assertArrayEquality(new Boolean[]{true, false, true, true});
    }

    public void testFloatArrayMarshalling() {
        this.assertArrayEquality(new Float[]{Float.valueOf(56789.9f), Float.valueOf(1234.6f), Float.valueOf(85894.305f), Float.valueOf(67484.32f), Float.valueOf(4732.4f)});
    }

    public void testDoubleArrayMarshalling() {
        this.assertArrayEquality(new Double[]{5.678E9, 1.623435E9, 565454.5, 96.232323});
    }

    public void testListMarshalling() {
        ArrayList<String> cities = new ArrayList<String>();
        cities.add("algorta");
        cities.add("neuchatel");
        cities.add("ibiza");
        this.assertEquality(cities);
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        numbers.add(12);
        numbers.add(3232412);
        numbers.add(4345132);
        numbers.add(898979);
        this.assertEquality(numbers);
        LinkedList<Boolean> testimony = new LinkedList<Boolean>();
        testimony.add(false);
        testimony.add(true);
        testimony.add(true);
        testimony.add(true);
        this.assertEquality(testimony);
    }

    public void testMapMarshalling() {
        HashMap<Long, Float> numbers = new HashMap<Long, Float>();
        numbers.put(Long.MAX_VALUE, Float.valueOf(4732.4f));
        numbers.put(0x100000000000000L, Float.valueOf(67484.32f));
        numbers.put(7205759412424936L, Float.valueOf(1.3236749E8f));
        this.assertEquality(numbers);
    }

    public void testSetMarshalling() {
        HashSet<String> words = new HashSet<String>();
        words.add("cat");
        words.add("dog");
        words.add("perro");
        words.add("txakur");
        this.assertEquality(words);
    }

    private Object marshallUnmarshall(Object o) {
        try {
            byte[] buffer = this.marshaller.objectToByteBuffer(o);
            return this.marshaller.objectFromByteBuffer(buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Error marshalling or unmarshalling", e);
        }
    }

    private <T> void assertArrayEquality(T[] x) {
        Object[] y = (Object[])this.marshallUnmarshall(x);
        assert (Arrays.equals(x, y));
    }

    private <T> void assertEquality(T x) {
        Object y = this.marshallUnmarshall(x);
        assert (x.equals(y));
    }
}

