/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.test;

import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.util.logging.LogFactory;

public class HotRodClientTestingUtil {
    private static final Log log = (Log)LogFactory.getLog(HotRodClientTestingUtil.class, Log.class);

    public static void killRemoteCacheManager(RemoteCacheManager rcm) {
        try {
            if (rcm != null) {
                rcm.stop();
            }
        }
        catch (Throwable t) {
            log.warn((Object)"Error stopping remote cache manager", t);
        }
    }

    public static void killRemoteCacheManagers(RemoteCacheManager ... rcms) {
        if (rcms != null) {
            for (RemoteCacheManager rcm : rcms) {
                try {
                    if (rcm == null) continue;
                    rcm.stop();
                }
                catch (Throwable t) {
                    log.warn((Object)"Error stopping remote cache manager", t);
                }
            }
        }
    }

    public static void killServers(HotRodServer ... servers) {
        if (servers != null) {
            for (HotRodServer server : servers) {
                try {
                    if (server == null) continue;
                    server.stop();
                }
                catch (Throwable t) {
                    log.warn((Object)"Error stopping Hot Rod server", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withRemoteCacheManager(RemoteCacheManagerCallable c) {
        try {
            c.call();
        }
        finally {
            HotRodClientTestingUtil.killRemoteCacheManager(c.rcm);
        }
    }
}

