/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ApacheCommonsPoolTest")
public class ApacheCommonsPoolTest {
    public void testBorrowValidObjectFromPool() throws Exception {
        KeyedObjectPool pool = BasicPoolFactory.createPoolFactory().createPool();
        String obj = (String)pool.borrowObject((Object)1);
        AssertJUnit.assertEquals((String)"1", (String)obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={TooHighException.class})
    public void testBorrowFromPoolException() throws Exception {
        GenericKeyedObjectPoolFactory<Integer, String> poolFactory = BasicPoolFactory.createPoolFactory();
        try {
            poolFactory.createPool().borrowObject((Object)Integer.MAX_VALUE);
        }
        finally {
            BasicPoolFactory basicPoolFactory = (BasicPoolFactory)poolFactory.getFactory();
            AssertJUnit.assertEquals((String)"invalid", (String)basicPoolFactory.getState(Integer.MAX_VALUE));
        }
    }

    public void testInvalidateBorrowFromPool() throws Exception {
        GenericKeyedObjectPoolFactory<Integer, String> poolFactory = BasicPoolFactory.createPoolFactory();
        KeyedObjectPool pool = poolFactory.createPool();
        try {
            pool.borrowObject((Object)Integer.MAX_VALUE);
            AssertJUnit.fail((String)"Should have thrown a TooHighException");
        }
        catch (TooHighException e) {
            pool.invalidateObject((Object)Integer.MAX_VALUE, null);
            BasicPoolFactory basicPoolFactory = (BasicPoolFactory)poolFactory.getFactory();
            AssertJUnit.assertEquals((String)"destroyed", (String)basicPoolFactory.getState(Integer.MAX_VALUE));
        }
    }

    private static class TooHighException
    extends RuntimeException {
        public TooHighException(String message) {
            super(message);
        }
    }

    private static class BasicPoolFactory
    extends BaseKeyedPoolableObjectFactory<Integer, String> {
        private Map<Integer, String> state = new HashMap<Integer, String>();

        private BasicPoolFactory() {
        }

        public String makeObject(Integer key) throws Exception {
            if (Integer.MAX_VALUE == key) {
                this.state.put(key, "invalid");
                throw new TooHighException("Too high");
            }
            return key.toString();
        }

        public void destroyObject(Integer key, String obj) throws Exception {
            this.state.put(key, "destroyed");
        }

        public String getState(Integer key) {
            return this.state.get(key);
        }

        public static GenericKeyedObjectPoolFactory<Integer, String> createPoolFactory() {
            return new GenericKeyedObjectPoolFactory((KeyedPoolableObjectFactory)new BasicPoolFactory());
        }
    }
}

