/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ClientAsymmetricClusterTest")
public class ClientAsymmetricClusterTest
extends MultiHotRodServersTest {
    private static final String CACHE_NAME = "asymmetricCache";

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)ClientAsymmetricClusterTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        this.createHotRodServers(2, builder);
        this.manager(0).defineConfiguration(CACHE_NAME, builder.build());
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*CacheNotFoundException.*")
    public void testAsymmetricCluster() {
        RemoteCacheManager client0 = this.client(0);
        RemoteCache cache0 = client0.getCache(CACHE_NAME);
        cache0.put((Object)1, (Object)"v1");
        AssertJUnit.assertEquals((Object)"v1", (Object)cache0.get((Object)1));
        cache0.put((Object)2, (Object)"v1");
        AssertJUnit.assertEquals((Object)"v1", (Object)cache0.get((Object)2));
        cache0.put((Object)3, (Object)"v1");
        AssertJUnit.assertEquals((Object)"v1", (Object)cache0.get((Object)3));
    }
}

