/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.URL;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.RemoteCacheManagerTest", groups={"functional"})
public class RemoteCacheManagerTest
extends SingleCacheManagerTest {
    HotRodServer hotrodServer;
    int port;
    RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.port = this.hotrodServer.getPort();
        this.remoteCacheManager = null;
    }

    @AfterTest
    public void release() {
        try {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
            HotRodClientTestingUtil.killServers(this.hotrodServer);
            HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testNoArgConstructor() {
        this.remoteCacheManager = new RemoteCacheManager();
        AssertJUnit.assertTrue((boolean)this.remoteCacheManager.isStarted());
    }

    public void testBooleanConstructor() {
        this.remoteCacheManager = new RemoteCacheManager(false);
        AssertJUnit.assertFalse((boolean)this.remoteCacheManager.isStarted());
        this.remoteCacheManager.start();
    }

    public void testConfigurationConstructor() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.port);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        AssertJUnit.assertTrue((boolean)this.remoteCacheManager.isStarted());
    }

    public void testUrlAndBooleanConstructor() throws Exception {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("empty-config.properties");
        assert (resource != null);
        this.remoteCacheManager = new RemoteCacheManager(resource, false);
        assert (!this.remoteCacheManager.isStarted());
        Properties properties = this.remoteCacheManager.getProperties();
        properties.setProperty("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.port);
        this.remoteCacheManager = new RemoteCacheManager(properties, false);
        assert (!this.remoteCacheManager.isStarted());
        this.remoteCacheManager.start();
        this.assertWorks(this.remoteCacheManager);
    }

    public void testPropertiesConstructor() {
        Properties p = new Properties();
        p.setProperty("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.port);
        this.remoteCacheManager = new RemoteCacheManager(p);
        assert (this.remoteCacheManager.isStarted());
        this.assertWorks(this.remoteCacheManager);
        this.remoteCacheManager.stop();
    }

    public void testPropertiesAndBooleanConstructor() {
        Properties p = new Properties();
        p.setProperty("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.port);
        this.remoteCacheManager = new RemoteCacheManager(p, false);
        assert (!this.remoteCacheManager.isStarted());
        this.remoteCacheManager.start();
        this.assertWorks(this.remoteCacheManager);
    }

    public void testStringAndBooleanConstructor() {
        this.remoteCacheManager = new RemoteCacheManager("localhost:" + this.hotrodServer.getPort(), false);
        assert (!this.remoteCacheManager.isStarted());
        this.remoteCacheManager.start();
        this.assertWorks(this.remoteCacheManager);
    }

    public void testGetUndefinedCache() {
        Properties p = new Properties();
        p.setProperty("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.port);
        this.remoteCacheManager = new RemoteCacheManager(p, false);
        assert (!this.remoteCacheManager.isStarted());
        this.remoteCacheManager.start();
        assert (null == this.remoteCacheManager.getCache("Undefined1234"));
    }

    private void assertWorks(RemoteCacheManager remoteCacheManager) {
        RemoteCache cache = remoteCacheManager.getCache();
        cache.put((Object)"aKey", (Object)"aValue");
        assert (cache.get((Object)"aKey").equals("aValue"));
    }

    public void testMarshallerInstance() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.port);
        GenericJBossMarshaller marshaller = new GenericJBossMarshaller();
        builder.marshaller((Marshaller)marshaller);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        AssertJUnit.assertTrue((marshaller == this.remoteCacheManager.getMarshaller() ? 1 : 0) != 0);
    }
}

