/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.HotRodIntegrationTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ServerRestartTest", groups={"functional"})
public class ServerRestartTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(HotRodIntegrationTest.class);
    private RemoteCache<String, String> defaultRemote;
    private RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort()).connectionPool().timeBetweenEvictionRuns(2000L);
        this.remoteCacheManager = new RemoteCacheManager(builder.build());
        this.defaultRemote = this.remoteCacheManager.getCache();
    }

    @AfterClass
    public void testDestroyRemoteCacheFactory() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testServerShutdown() throws Exception {
        this.defaultRemote.put((Object)"k", (Object)"v");
        assert (((String)this.defaultRemote.get((Object)"k")).equals("v"));
        int port = this.hotrodServer.getPort();
        this.hotrodServer.stop();
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        ((HotRodServerConfigurationBuilder)((HotRodServerConfigurationBuilder)((HotRodServerConfigurationBuilder)((HotRodServerConfigurationBuilder)((HotRodServerConfigurationBuilder)((HotRodServerConfigurationBuilder)builder.host("127.0.0.1")).port(port)).workerThreads(2)).idleTimeout(20000)).tcpNoDelay(true)).sendBufSize(15000)).recvBufSize(25000);
        this.hotrodServer.start(builder.build(), this.cacheManager);
        Thread.sleep(3000L);
        assert (((String)this.defaultRemote.get((Object)"k")).equals("v"));
        this.defaultRemote.put((Object)"k", (Object)"v");
    }
}

