/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.util.Date;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.EmbeddedAccount;
import org.infinispan.client.hotrod.marshall.EmbeddedAccountMarshaller;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.Account;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.remote.CompatibilityProtoStreamMarshaller;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.EmbeddedCompatTest", groups={"functional"})
@CleanupAfterMethod
public class EmbeddedCompatTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, Account> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.compatibility().enable().marshaller((Marshaller)new CompatibilityProtoStreamMarshaller());
        builder.indexing().enable().addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        builder.dataContainer().keyEquivalence((Equivalence)AnyEquivalence.getInstance());
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = TestHelper.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
        ProtobufMetadataManager protobufMetadataManager = (ProtobufMetadataManager)this.cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        protobufMetadataManager.registerProtofile("/bank.protobin");
        protobufMetadataManager.registerMarshaller(EmbeddedAccount.class, (BaseMarshaller)new EmbeddedAccountMarshaller());
        return this.cacheManager;
    }

    @AfterTest
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testPutAndGet() throws Exception {
        Account account = this.createAccount();
        this.remoteCache.put((Object)1, (Object)account);
        Assert.assertEquals((long)1L, (long)this.cache.keySet().size());
        Object key = this.cache.keySet().iterator().next();
        Object localObject = this.cache.get(key);
        Assert.assertNotNull((Object)localObject);
        Assert.assertTrue((boolean)(localObject instanceof EmbeddedAccount));
        this.assertEmbeddedAccount((EmbeddedAccount)localObject);
        Account fromRemoteCache = (Account)this.remoteCache.get((Object)1);
        this.assertAccount(fromRemoteCache);
    }

    public void testRemoteQuery() throws Exception {
        Account account = this.createAccount();
        this.remoteCache.put((Object)1, (Object)account);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(Account.class).having("description").like("%test%").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Account.class, ((Account)list.get(0)).getClass());
        this.assertAccount((Account)list.get(0));
    }

    public void testEmbeddedQuery() throws Exception {
        Account account = this.createAccount();
        this.remoteCache.put((Object)1, (Object)account);
        org.apache.lucene.search.Query query = org.infinispan.query.Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(EmbeddedAccount.class).get().keyword().wildcard().onField("description").matching((Object)"*test*").createQuery();
        CacheQuery cacheQuery = org.infinispan.query.Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List list = cacheQuery.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(EmbeddedAccount.class, list.get(0).getClass());
        this.assertEmbeddedAccount((EmbeddedAccount)list.get(0));
    }

    private Account createAccount() {
        Account account = new Account();
        account.setId(1);
        account.setDescription("test description");
        account.setCreationDate(new Date(42L));
        return account;
    }

    private void assertAccount(Account account) {
        Assert.assertEquals((long)1L, (long)account.getId());
        Assert.assertEquals((Object)"test description", (Object)account.getDescription());
        Assert.assertEquals((long)42L, (long)account.getCreationDate().getTime());
    }

    private void assertEmbeddedAccount(EmbeddedAccount account) {
        Assert.assertEquals((long)1L, (long)account.getId());
        Assert.assertEquals((Object)"test description", (Object)account.getDescription());
        Assert.assertEquals((long)42L, (long)account.getCreationDate().getTime());
    }
}

