/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.Collections;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.MultiHotRodServerQueryTest", groups={"functional"})
public class MultiHotRodServerQueryTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)MultiHotRodServerQueryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
        builder.indexing().enable().addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.createHotRodServers(2, builder);
        for (EmbeddedCacheManager cm : this.cacheManagers) {
            ((ProtobufMetadataManager)cm.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class)).registerProtofile("/bank.protobin");
        }
        for (RemoteCacheManager rcm : this.clients) {
            MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)rcm));
        }
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        return super.createHotRodClientConfigurationBuilder(serverPort).marshaller((Marshaller)new ProtoStreamMarshaller());
    }

    public void testAttributeQuery() throws Exception {
        RemoteCache remoteCache0 = this.client(0).getCache();
        RemoteCache remoteCache1 = this.client(1).getCache();
        remoteCache0.put((Object)1, (Object)this.createUser1());
        remoteCache1.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)remoteCache0.get((Object)1);
        this.assertUser(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)remoteCache1);
        Query query = qf.from(User.class).having("name").eq((Object)"Tom").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser((User)list.get(0));
    }

    public void testEmbeddedAttributeQuery() throws Exception {
        RemoteCache remoteCache0 = this.client(0).getCache();
        RemoteCache remoteCache1 = this.client(1).getCache();
        remoteCache0.put((Object)1, (Object)this.createUser1());
        remoteCache1.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory((RemoteCache)remoteCache1);
        Query query = qf.from(User.class).having("addresses.postCode").eq((Object)"1234").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser((User)list.get(0));
    }

    public void testProjections() throws Exception {
        RemoteCache remoteCache0 = this.client(0).getCache();
        RemoteCache remoteCache1 = this.client(1).getCache();
        remoteCache0.put((Object)1, (Object)this.createUser1());
        remoteCache1.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)remoteCache0.get((Object)1);
        this.assertUser(fromCache);
        QueryFactory qf = Search.getQueryFactory((RemoteCache)remoteCache1);
        Query query = qf.from(User.class).setProjection(new String[]{"name", "surname"}).having("name").eq((Object)"Tom").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        Assert.assertEquals((Object)"Tom", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Cat", (Object)((Object[])list.get(0))[1]);
    }

    private User createUser1() {
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singletonList(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private User createUser2() {
        User user = new User();
        user.setId(2);
        user.setName("Adrian");
        user.setSurname("Nistor");
        user.setGender(User.Gender.MALE);
        Address address = new Address();
        address.setStreet("Old Street");
        address.setPostCode("XYZ");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private void assertUser(User user) {
        Assert.assertEquals((long)1L, (long)user.getId());
        Assert.assertEquals((Object)"Tom", (Object)user.getName());
        Assert.assertEquals((Object)"Cat", (Object)user.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        Assert.assertNotNull((Object)user.getAccountIds());
        Assert.assertEquals((long)1L, (long)user.getAccountIds().size());
        Assert.assertEquals((long)12L, (long)((Integer)user.getAccountIds().get(0)).intValue());
        Assert.assertNotNull((Object)user.getAddresses());
        Assert.assertEquals((long)1L, (long)user.getAddresses().size());
        Assert.assertEquals((Object)"Dark Alley", (Object)((Address)user.getAddresses().get(0)).getStreet());
        Assert.assertEquals((Object)"1234", (Object)((Address)user.getAddresses().get(0)).getPostCode());
    }
}

