/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.test;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;

public abstract class MultiHotRodServersTest
extends MultipleCacheManagersTest {
    protected List<HotRodServer> servers = new ArrayList<HotRodServer>();
    protected List<RemoteCacheManager> clients = new ArrayList<RemoteCacheManager>();

    protected void createHotRodServers(int num, org.infinispan.configuration.cache.ConfigurationBuilder defaultBuilder) {
        int i;
        for (i = 0; i < num; ++i) {
            this.addHotRodServer(defaultBuilder);
        }
        for (i = 0; i < num; ++i) {
            assert (this.manager(i).getCache() != null);
        }
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)num);
        for (i = 0; i < num; ++i) {
            TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(i).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        }
        for (i = 0; i < num; ++i) {
            this.clients.add(new RemoteCacheManager(this.createHotRodClientConfigurationBuilder(this.server(i).getPort()).build()));
        }
    }

    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(int serverPort) {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(serverPort).pingOnStartup(false);
        return clientBuilder;
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        try {
            for (HotRodServer server : this.servers) {
                HotRodClientTestingUtil.killServers(server);
            }
        }
        finally {
            super.destroy();
        }
    }

    private HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServer server = TestHelper.startHotRodServer(cm);
        this.servers.add(server);
        return server;
    }

    protected HotRodServer server(int i) {
        return this.servers.get(i);
    }

    protected RemoteCacheManager client(int i) {
        return this.clients.get(i);
    }
}

