/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.SomeAsyncExecutorFactory;
import org.infinispan.client.hotrod.SomeCustomConsistentHashV1;
import org.infinispan.client.hotrod.SomeRequestBalancingStrategy;
import org.infinispan.client.hotrod.SomeTransportfactory;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.ConfigurationTest", groups={"functional"})
public class ConfigurationTest {
    public void testConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("host1").port(11222).addServer().host("host2").port(11222).asyncExecutorFactory().factoryClass(SomeAsyncExecutorFactory.class).balancingStrategy(SomeRequestBalancingStrategy.class).connectionPool().maxActive(100).maxTotal(150).maxWait(1000L).maxIdle(20).minIdle(10).exhaustedAction(ExhaustedAction.WAIT).numTestsPerEvictionRun(5).testOnBorrow(true).testOnReturn(true).testWhileIdle(false).minEvictableIdleTime(12000L).timeBetweenEvictionRuns(15000L).connectionTimeout(100).consistentHashImpl(1, SomeCustomConsistentHashV1.class).socketTimeout(100).tcpNoDelay(false).pingOnStartup(false).keySizeEstimate(128).valueSizeEstimate(1024).transportFactory(SomeTransportfactory.class);
        Configuration configuration = builder.build();
        this.validateConfiguration(configuration);
        ConfigurationBuilder newBuilder = new ConfigurationBuilder();
        newBuilder.read(configuration);
        Configuration newConfiguration = newBuilder.build();
        this.validateConfiguration(newConfiguration);
    }

    private void validateConfiguration(Configuration configuration) {
        AssertJUnit.assertEquals((int)2, (int)configuration.servers().size());
        AssertJUnit.assertEquals(SomeAsyncExecutorFactory.class, (Object)configuration.asyncExecutorFactory().factoryClass());
        AssertJUnit.assertEquals(SomeRequestBalancingStrategy.class, (Object)configuration.balancingStrategy());
        AssertJUnit.assertEquals(SomeTransportfactory.class, (Object)configuration.transportFactory());
        AssertJUnit.assertEquals(SomeCustomConsistentHashV1.class, (Object)configuration.consistentHashImpl(1));
        AssertJUnit.assertEquals((int)100, (int)configuration.connectionPool().maxActive());
        AssertJUnit.assertEquals((int)150, (int)configuration.connectionPool().maxTotal());
        AssertJUnit.assertEquals((long)1000L, (long)configuration.connectionPool().maxWait());
        AssertJUnit.assertEquals((int)20, (int)configuration.connectionPool().maxIdle());
        AssertJUnit.assertEquals((int)10, (int)configuration.connectionPool().minIdle());
        AssertJUnit.assertEquals((Object)ExhaustedAction.WAIT, (Object)configuration.connectionPool().exhaustedAction());
        AssertJUnit.assertEquals((int)5, (int)configuration.connectionPool().numTestsPerEvictionRun());
        AssertJUnit.assertEquals((long)15000L, (long)configuration.connectionPool().timeBetweenEvictionRuns());
        AssertJUnit.assertEquals((long)12000L, (long)configuration.connectionPool().minEvictableIdleTime());
        AssertJUnit.assertTrue((boolean)configuration.connectionPool().testOnBorrow());
        AssertJUnit.assertTrue((boolean)configuration.connectionPool().testOnReturn());
        AssertJUnit.assertFalse((boolean)configuration.connectionPool().testWhileIdle());
        AssertJUnit.assertEquals((int)100, (int)configuration.connectionTimeout());
        AssertJUnit.assertEquals((int)100, (int)configuration.socketTimeout());
        AssertJUnit.assertFalse((boolean)configuration.tcpNoDelay());
        AssertJUnit.assertFalse((boolean)configuration.pingOnStartup());
        AssertJUnit.assertEquals((int)128, (int)configuration.keySizeEstimate());
        AssertJUnit.assertEquals((int)1024, (int)configuration.valueSizeEstimate());
    }
}

