/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.sampledomain.Address;
import org.infinispan.protostream.sampledomain.User;
import org.infinispan.protostream.sampledomain.marshallers.MarshallerRegistration;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.HotRodQueryTest", groups={"functional"})
@CleanupAfterMethod
public class HotRodQueryTest
extends SingleCacheManagerTest {
    public static final String JMX_DOMAIN = ProtobufMetadataManager.class.getSimpleName();
    public static final String TEST_CACHE_NAME = "userCache";
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, User> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        gcb.globalJmxStatistics().enable().allowDuplicateDomains(Boolean.valueOf(true)).jmxDomain(JMX_DOMAIN).mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup());
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.dataContainer().keyEquivalence(ByteArrayEquivalence.INSTANCE).indexing().enable().addProperty("default.directory_provider", this.getLuceneDirectoryProvider()).addProperty("lucene_version", "LUCENE_CURRENT");
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)gcb, (org.infinispan.configuration.cache.ConfigurationBuilder)new org.infinispan.configuration.cache.ConfigurationBuilder(), (boolean)true);
        this.cacheManager.defineConfiguration(TEST_CACHE_NAME, builder.build());
        this.cache = this.cacheManager.getCache(TEST_CACHE_NAME);
        this.hotRodServer = TestHelper.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache(TEST_CACHE_NAME);
        ObjectName objName = new ObjectName(JMX_DOMAIN + ":type=RemoteQuery,name=" + ObjectName.quote("DefaultCacheManager") + ",component=" + "ProtobufMetadataManager");
        byte[] descriptor = this.readClasspathResource("/bank.protobin");
        MBeanServer mBeanServer = PerThreadMBeanServerLookup.getThreadMBeanServer();
        mBeanServer.invoke(objName, "registerProtofile", new Object[]{descriptor}, new String[]{byte[].class.getName()});
        MarshallerRegistration.registerMarshallers((SerializationContext)ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
        return this.cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readClasspathResource(String classPathResource) throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(classPathResource);
        try {
            int len;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    protected String getLuceneDirectoryProvider() {
        return "ram";
    }

    @AfterTest
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testAttributeQuery() throws Exception {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)this.remoteCache.get((Object)1);
        this.assertUser(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(User.class).having("name").eq((Object)"Tom").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser((User)list.get(0));
    }

    public void testEmbeddedAttributeQuery() throws Exception {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(User.class).having("addresses.postCode").eq((Object)"1234").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(User.class, ((User)list.get(0)).getClass());
        this.assertUser((User)list.get(0));
    }

    public void testProjections() throws Exception {
        this.remoteCache.put((Object)1, (Object)this.createUser1());
        this.remoteCache.put((Object)2, (Object)this.createUser2());
        User fromCache = (User)this.remoteCache.get((Object)1);
        this.assertUser(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(User.class).setProjection(new String[]{"name", "surname"}).having("name").eq((Object)"Tom").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        Assert.assertEquals((Object)"Tom", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Cat", (Object)((Object[])list.get(0))[1]);
    }

    private User createUser1() {
        User user = new User();
        user.setId(1);
        user.setName("Tom");
        user.setSurname("Cat");
        user.setGender(User.Gender.MALE);
        user.setAccountIds(Collections.singletonList(12));
        Address address = new Address();
        address.setStreet("Dark Alley");
        address.setPostCode("1234");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private User createUser2() {
        User user = new User();
        user.setId(1);
        user.setName("Adrian");
        user.setSurname("Nistor");
        user.setGender(User.Gender.MALE);
        Address address = new Address();
        address.setStreet("Old Street");
        address.setPostCode("XYZ");
        user.setAddresses(Collections.singletonList(address));
        return user;
    }

    private void assertUser(User user) {
        Assert.assertEquals((long)1L, (long)user.getId());
        Assert.assertEquals((Object)"Tom", (Object)user.getName());
        Assert.assertEquals((Object)"Cat", (Object)user.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        Assert.assertNotNull((Object)user.getAccountIds());
        Assert.assertEquals((long)1L, (long)user.getAccountIds().size());
        Assert.assertEquals((long)12L, (long)((Integer)user.getAccountIds().get(0)).intValue());
        Assert.assertNotNull((Object)user.getAddresses());
        Assert.assertEquals((long)1L, (long)user.getAddresses().size());
        Assert.assertEquals((Object)"Dark Alley", (Object)((Address)user.getAddresses().get(0)).getStreet());
        Assert.assertEquals((Object)"1234", (Object)((Address)user.getAddresses().get(0)).getPostCode());
    }
}

