/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.VersionedOperationResponse;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.commons.logging.BasicLogFactory;
import org.infinispan.commons.util.Util;
import org.jboss.logging.BasicLogger;

@Immutable
public abstract class AbstractKeyOperation<T>
extends RetryOnFailureOperation<T> {
    private static final BasicLogger log = BasicLogFactory.getLog(AbstractKeyOperation.class);
    protected final byte[] key;

    protected AbstractKeyOperation(Codec codec, TransportFactory transportFactory, byte[] key, byte[] cacheName, AtomicInteger topologyId, Flag[] flags) {
        super(codec, transportFactory, cacheName, topologyId, flags);
        this.key = key;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        if (retryCount == 0) {
            return this.transportFactory.getTransport(this.key, failedServers, this.cacheName);
        }
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }

    protected short sendKeyOperation(byte[] key, Transport transport, byte opCode, byte opRespCode) {
        HeaderParams params = this.writeHeader(transport, opCode);
        transport.writeArray(key);
        transport.flush();
        return this.readHeaderAndValidate(transport, params);
    }

    protected byte[] returnPossiblePrevValue(Transport transport) {
        if (this.hasForceReturn(this.flags)) {
            byte[] bytes = transport.readArray();
            if (log.isTraceEnabled()) {
                log.tracef("Previous value bytes is: %s", (Object)Util.printArray((byte[])bytes, (boolean)false));
            }
            return bytes.length == 0 ? null : bytes;
        }
        return null;
    }

    private boolean hasForceReturn(Flag[] flags) {
        if (flags == null) {
            return false;
        }
        for (Flag flag : flags) {
            if (flag != Flag.FORCE_RETURN_VALUE) continue;
            return true;
        }
        return false;
    }

    protected VersionedOperationResponse returnVersionedOperationResponse(Transport transport, HeaderParams params) {
        VersionedOperationResponse.RspCode code;
        short respStatus = this.readHeaderAndValidate(transport, params);
        if (respStatus == 0) {
            code = VersionedOperationResponse.RspCode.SUCCESS;
        } else if (respStatus == 1) {
            code = VersionedOperationResponse.RspCode.MODIFIED_KEY;
        } else if (respStatus == 2) {
            code = VersionedOperationResponse.RspCode.NO_SUCH_KEY;
        } else {
            throw new IllegalStateException("Unknown response status: " + Integer.toHexString(respStatus));
        }
        byte[] prevValue = this.returnPossiblePrevValue(transport);
        return new VersionedOperationResponse(prevValue, code);
    }
}

