/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.CSAIntegrationTest")
public class CSAIntegrationTest
extends HitsAwareCacheManagersTest {
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;
    private HotRodServer hotRodServer3;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;
    private TcpTransportFactory tcpConnectionFactory;
    private static final Log log = LogFactory.getLog(CSAIntegrationTest.class);

    @AfterMethod
    protected void clearContent() throws Throwable {
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)CSAIntegrationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.clustering().hash().numOwners(1);
        builder.unsafe().unreliableReturnValues(true);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.hotRodServer1 = TestHelper.startHotRodServer(this.manager(0));
        this.hrServ2CacheManager.put(new InetSocketAddress(this.hotRodServer1.getHost(), this.hotRodServer1.getPort()), this.manager(0));
        this.hotRodServer2 = TestHelper.startHotRodServer(this.manager(1));
        this.hrServ2CacheManager.put(new InetSocketAddress(this.hotRodServer2.getHost(), this.hotRodServer2.getPort()), this.manager(1));
        this.hotRodServer3 = TestHelper.startHotRodServer(this.manager(2));
        this.hrServ2CacheManager.put(new InetSocketAddress(this.hotRodServer3.getHost(), this.hotRodServer3.getPort()), this.manager(2));
        assert (this.manager(0).getCache() != null);
        assert (this.manager(1).getCache() != null);
        assert (this.manager(2).getCache() != null);
        TestingUtil.blockUntilViewReceived((Cache)this.manager(0).getCache(), (int)3);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(0).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(1).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        TestingUtil.blockUntilCacheStatusAchieved((Cache)this.manager(2).getCache(), (ComponentStatus)ComponentStatus.RUNNING, (long)10000L);
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer2.getPort() + ";localhost:" + this.hotRodServer2.getPort());
        props.put("infinispan.client.hotrod.ping_on_startup", "true");
        this.setHotRodProtocolVersion(props);
        this.remoteCacheManager = new RemoteCacheManager(props);
        this.remoteCache = this.remoteCacheManager.getCache();
        this.tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transportFactory");
    }

    protected void setHotRodProtocolVersion(Properties props) {
    }

    @AfterClass
    protected void destroy() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2, this.hotRodServer3);
        super.destroy();
    }

    public void testHashInfoRetrieved() throws InterruptedException {
        AssertJUnit.assertEquals((int)3, (int)this.tcpConnectionFactory.getServers().size());
        for (int i = 0; i < 10; ++i) {
            this.remoteCache.put((Object)"k", (Object)"v");
            if (this.tcpConnectionFactory.getServers().size() == 3) break;
            Thread.sleep(1000L);
        }
        AssertJUnit.assertEquals((int)3, (int)this.tcpConnectionFactory.getServers().size());
        AssertJUnit.assertNotNull((Object)this.tcpConnectionFactory.getConsistentHash(RemoteCacheManager.cacheNameBytes()));
    }

    @Test(dependsOnMethods={"testHashInfoRetrieved"})
    public void testCorrectSetup() {
        this.remoteCache.put((Object)"k", (Object)"v");
        assert (this.remoteCache.get((Object)"k").equals("v"));
    }

    @Test(dependsOnMethods={"testCorrectSetup"})
    public void testHashFunctionReturnsSameValues() {
        for (int i = 0; i < 1000; ++i) {
            byte[] key = this.generateKey(i);
            TcpTransport transport = (TcpTransport)this.tcpConnectionFactory.getTransport(key, null, RemoteCacheManager.cacheNameBytes());
            SocketAddress serverAddress = transport.getServerAddress();
            CacheContainer cacheContainer = (CacheContainer)this.hrServ2CacheManager.get(serverAddress);
            AssertJUnit.assertNotNull((String)("For server address " + serverAddress + " found " + cacheContainer + ". Map is: " + this.hrServ2CacheManager), (Object)cacheContainer);
            DistributionManager distributionManager = cacheContainer.getCache().getAdvancedCache().getDistributionManager();
            Address clusterAddress = cacheContainer.getCache().getAdvancedCache().getRpcManager().getAddress();
            ConsistentHash serverCh = distributionManager.getReadConsistentHash();
            int numSegments = serverCh.getNumSegments();
            int keySegment = serverCh.getSegment((Object)key);
            Address serverOwner = serverCh.locatePrimaryOwnerForSegment(keySegment);
            Address serverPreviousOwner = serverCh.locatePrimaryOwnerForSegment((keySegment - 1 + numSegments) % numSegments);
            assert (clusterAddress.equals(serverOwner) || clusterAddress.equals(serverPreviousOwner));
            this.tcpConnectionFactory.releaseTransport((Transport)transport);
        }
    }

    @Test(dependsOnMethods={"testHashFunctionReturnsSameValues"})
    public void testRequestsGoToExpectedServer() throws Exception {
        TcpTransport transport;
        String keyStr;
        this.addInterceptors();
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (int i = 0; i < 500; ++i) {
            byte[] key = this.generateKey(i);
            keys.add(key);
            keyStr = new String(key);
            this.remoteCache.put((Object)keyStr, (Object)"value");
            transport = (TcpTransport)this.tcpConnectionFactory.getTransport(HotRodTestingUtil.marshall((String)keyStr), null, RemoteCacheManager.cacheNameBytes());
            HotRodTestingUtil.assertHotRodEquals((EmbeddedCacheManager)((EmbeddedCacheManager)this.hrServ2CacheManager.get(transport.getServerAddress())), (String)keyStr, (String)"value");
            this.tcpConnectionFactory.releaseTransport((Transport)transport);
        }
        log.info((Object)"Right before first get.");
        for (byte[] key : keys) {
            this.resetStats();
            keyStr = new String(key);
            assert (this.remoteCache.get((Object)keyStr).equals("value"));
            transport = (TcpTransport)this.tcpConnectionFactory.getTransport(HotRodTestingUtil.marshall((String)keyStr), null, RemoteCacheManager.cacheNameBytes());
            this.assertOnlyServerHit(transport.getServerAddress());
            this.tcpConnectionFactory.releaseTransport((Transport)transport);
        }
    }

    private byte[] generateKey(int i) {
        Random r = new Random();
        byte[] result = new byte[i];
        r.nextBytes(result);
        return result;
    }
}

