/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.Properties;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.EntryWrappingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.JBossMarshaller;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.SocketTimeoutErrorTest")
public class SocketTimeoutErrorTest
extends SingleCacheManagerTest {
    protected HotRodServer hotrodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.customInterceptors().addInterceptor().interceptor((CommandInterceptor)new TimeoutInducingInterceptor()).after(EntryWrappingInterceptor.class);
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder));
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = TestHelper.startHotRodServer(this.cacheManager);
        this.remoteCacheManager = new RemoteCacheManager(this.getClientProperties());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        super.teardown();
    }

    protected Properties getClientProperties() {
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.hotrodServer.getPort());
        props.setProperty("infinispan.client.hotrod.socket_timeout", "3000");
        props.setProperty("maxActive", "1");
        props.setProperty("maxTotal", "1");
        props.setProperty("maxIdle", "1");
        return props;
    }

    public void testErrorWhileDoingPut(Method m) throws Exception {
        block3: {
            this.remoteCache = this.remoteCacheManager.getCache();
            this.remoteCache.put((Object)TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m));
            assert (this.remoteCache.get((Object)TestingUtil.k((Method)m)).equals(TestingUtil.v((Method)m)));
            try {
                this.remoteCache.put((Object)"FailFailFail", (Object)"whatever...");
                Assert.fail((String)"No exception was thrown.");
            }
            catch (HotRodClientException e) {
                if ($assertionsDisabled || e.getCause() instanceof SocketTimeoutException) break block3;
                throw new AssertionError();
            }
        }
    }

    public static class TimeoutInducingInterceptor
    extends CommandInterceptor {
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (this.unmarshall(command.getKey()).equals("FailFailFail")) {
                Thread.sleep(6000L);
            }
            return super.visitPutKeyValueCommand(ctx, command);
        }

        private String unmarshall(Object key) throws Exception {
            JBossMarshaller marshaller = new JBossMarshaller();
            return (String)marshaller.objectFromByteBuffer((byte[])key);
        }
    }
}

