/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import io.netty.channel.ChannelException;
import java.net.BindException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TestHelper {
    private static final Log log = LogFactory.getLog(TestHelper.class);
    private static final AtomicInteger uniquePort = new AtomicInteger(15232);

    public static HotRodServer startHotRodServer(EmbeddedCacheManager cacheManager, HotRodServerConfigurationBuilder builder) {
        HotRodServer server = null;
        int maxTries = 10;
        int currentTries = 0;
        ChannelException lastException = null;
        while (server == null && currentTries < maxTries) {
            try {
                server = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)cacheManager, (int)uniquePort.incrementAndGet(), (HotRodServerConfigurationBuilder)builder);
            }
            catch (ChannelException e) {
                if (!(e.getCause() instanceof BindException)) {
                    throw e;
                }
                log.debug((Object)("Address already in use: [" + e.getMessage() + "], so let's try next port"));
                ++currentTries;
                lastException = e;
            }
        }
        if (server == null && lastException != null) {
            throw lastException;
        }
        return server;
    }

    public static HotRodServer startHotRodServer(EmbeddedCacheManager cacheManager) {
        return TestHelper.startHotRodServer(cacheManager, new HotRodServerConfigurationBuilder());
    }

    public static String getServersString(HotRodServer ... servers) {
        StringBuilder builder = new StringBuilder();
        for (HotRodServer server : servers) {
            builder.append("localhost").append(':').append(server.getPort()).append(";");
        }
        return builder.toString();
    }

    public static RemoteCacheManager getRemoteCacheManager(HotRodServer server) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host(server.getHost()).port(server.getPort());
        return new RemoteCacheManager(builder.build());
    }

    public static byte[] getKeyForServer(HotRodServer primaryOwner) {
        return TestHelper.getKeyForServer(primaryOwner, null);
    }

    public static byte[] getKeyForServer(HotRodServer primaryOwner, String cacheName) {
        Cache cache = cacheName != null ? primaryOwner.getCacheManager().getCache(cacheName) : primaryOwner.getCacheManager().getCache();
        Random r = new Random();
        byte[] dummy = new byte[8];
        int attemptsLeft = 1000;
        do {
            r.nextBytes(dummy);
        } while (!DistributionTestHelper.isFirstOwner((Cache)cache, (Object)dummy) && attemptsLeft >= 0);
        if (attemptsLeft < 0) {
            throw new IllegalStateException("Could not find any key owned by " + primaryOwner);
        }
        log.infof("Binary key %s hashes to [cluster=%s,hotrod=%s]", (Object)Util.printArray((byte[])dummy, (boolean)false), (Object)primaryOwner.getCacheManager().getAddress(), (Object)primaryOwner.getAddress());
        return dummy;
    }
}

