/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.client.hotrod.event.CustomEventLogListener;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.test.RemoteCacheManagerCallable;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientClusterEventsTest")
public class ClientClusterEventsTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, this.getCacheConfiguration());
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfiguration() {
        return HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)ClientClusterEventsTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false));
    }

    @Override
    protected HotRodServer addHotRodServer(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(builder);
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        HotRodServer server = TestHelper.startHotRodServer(cm, serverBuilder);
        server.addCacheEventFilterFactory("static-filter-factory", (CacheEventFilterFactory)new EventLogListener.StaticCacheEventFilterFactory(), null);
        server.addCacheEventConverterFactory("static-converter-factory", (CacheEventConverterFactory)new CustomEventLogListener.StaticConverterFactory(), null);
        this.servers.add(server);
        return server;
    }

    public void testEventForwarding() {
        final EventLogListener eventListener = new EventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache c3 = ClientClusterEventsTest.this.client(2).getCache();
                eventListener.expectNoEvents();
                c3.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedEvent(1, ClientClusterEventsTest.this.cache(0));
                c3.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedEvent(2, ClientClusterEventsTest.this.cache(0));
                c3.put((Object)3, (Object)"three");
                eventListener.expectOnlyCreatedEvent(3, ClientClusterEventsTest.this.cache(0));
                c3.replace((Object)1, (Object)"new-one");
                eventListener.expectOnlyModifiedEvent(1, ClientClusterEventsTest.this.cache(0));
                c3.replace((Object)2, (Object)"new-two");
                eventListener.expectOnlyModifiedEvent(2, ClientClusterEventsTest.this.cache(0));
                c3.replace((Object)3, (Object)"new-three");
                eventListener.expectOnlyModifiedEvent(3, ClientClusterEventsTest.this.cache(0));
                c3.remove((Object)1);
                eventListener.expectOnlyRemovedEvent(1, ClientClusterEventsTest.this.cache(0));
                c3.remove((Object)2);
                eventListener.expectOnlyRemovedEvent(2, ClientClusterEventsTest.this.cache(0));
                c3.remove((Object)3);
                eventListener.expectOnlyRemovedEvent(3, ClientClusterEventsTest.this.cache(0));
            }
        });
    }

    public void testFilteringInCluster() {
        final EventLogListener.StaticFilteredEventLogListener eventListener = new EventLogListener.StaticFilteredEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache c3 = ClientClusterEventsTest.this.client(2).getCache();
                eventListener.expectNoEvents();
                c3.put((Object)1, (Object)"one");
                eventListener.expectNoEvents();
                c3.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedEvent(2, ClientClusterEventsTest.this.cache(0));
                c3.remove((Object)1);
                eventListener.expectNoEvents();
                c3.remove((Object)2);
                eventListener.expectOnlyRemovedEvent(2, ClientClusterEventsTest.this.cache(0));
            }
        });
    }

    public void testConversionInCluster() {
        final CustomEventLogListener.StaticCustomEventLogListener eventListener = new CustomEventLogListener.StaticCustomEventLogListener();
        HotRodClientTestingUtil.withClientListener(eventListener, new RemoteCacheManagerCallable(this.client(0)){

            @Override
            public void call() {
                RemoteCache c3 = ClientClusterEventsTest.this.client(2).getCache();
                eventListener.expectNoEvents();
                c3.put((Object)1, (Object)"one");
                eventListener.expectOnlyCreatedCustomEvent(1, "one");
                c3.put((Object)2, (Object)"two");
                eventListener.expectOnlyCreatedCustomEvent(2, "two");
                c3.remove((Object)1);
                eventListener.expectOnlyRemovedCustomEvent(1, null);
                c3.remove((Object)2);
                eventListener.expectOnlyRemovedCustomEvent(2, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEventReplayWithAndWithoutStateAfterFailover() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        HotRodServer server = this.server(0);
        builder.addServers(server.getHost() + ":" + server.getPort());
        builder.balancingStrategy(FirstServerAvailableBalancer.class);
        RemoteCacheManager newClient = new RemoteCacheManager(builder.build());
        try {
            WithStateEventLogListener<Integer> withStateEventLogListener = new WithStateEventLogListener<Integer>();
            EventLogListener<Integer> withoutStateEventLogListener = new EventLogListener<Integer>();
            RemoteCache c = newClient.getCache();
            c.put((Object)0, (Object)"zero");
            c.remove((Object)0);
            c.addClientListener(withoutStateEventLogListener);
            c.addClientListener(withStateEventLogListener);
            c.put((Object)1, (Object)"one");
            withStateEventLogListener.expectOnlyCreatedEvent(1, this.cache(0));
            withoutStateEventLogListener.expectOnlyCreatedEvent(1, this.cache(0));
            this.findServerAndKill(FirstServerAvailableBalancer.serverToKill);
            c.put((Object)2, (Object)"two");
            withoutStateEventLogListener.expectFailoverEvent();
            withStateEventLogListener.expectFailoverEvent();
            withoutStateEventLogListener.expectNoEvents();
            withStateEventLogListener.expectUnorderedEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, 1, 2);
            c.remove((Object)1);
            c.remove((Object)2);
        }
        finally {
            HotRodClientTestingUtil.killRemoteCacheManager(newClient);
        }
    }

    private void findServerAndKill(InetSocketAddress addr) {
        for (HotRodServer server : this.servers) {
            if (server.getPort() != addr.getPort()) continue;
            HotRodClientTestingUtil.killServers(server);
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{server.getCacheManager()});
            this.cacheManagers.remove(server.getCacheManager());
            TestingUtil.blockUntilViewsReceived((int)50000, (boolean)false, (Collection)this.cacheManagers);
        }
    }

    @ClientListener(includeCurrentState=true)
    public static class WithStateEventLogListener<K>
    extends EventLogListener<K> {
    }

    public static class FirstServerAvailableBalancer
    implements FailoverRequestBalancingStrategy {
        static Log log = LogFactory.getLog(FirstServerAvailableBalancer.class);
        static InetSocketAddress serverToKill;
        private final RoundRobinBalancingStrategy delegate = new RoundRobinBalancingStrategy();

        public void setServers(Collection<SocketAddress> servers) {
            log.info((Object)("Set servers: " + servers));
            this.delegate.setServers(servers);
            serverToKill = (InetSocketAddress)servers.iterator().next();
        }

        public SocketAddress nextServer(Set<SocketAddress> failedServers) {
            if (failedServers != null && !failedServers.isEmpty()) {
                return this.delegate.nextServer(failedServers);
            }
            log.info((Object)("Select " + serverToKill + " for load balancing"));
            return serverToKill;
        }

        public SocketAddress nextServer() {
            return this.nextServer(null);
        }
    }
}

