/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCustomEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterFactory;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.notifications.cachelistener.filter.NamedFactory;
import org.testng.AssertJUnit;

@ClientListener(converterFactoryName="test-converter-factory")
public abstract class CustomEventLogListener {
    BlockingQueue<CustomEvent> createdCustomEvents = new ArrayBlockingQueue<CustomEvent>(128);
    BlockingQueue<CustomEvent> modifiedCustomEvents = new ArrayBlockingQueue<CustomEvent>(128);
    BlockingQueue<CustomEvent> removedCustomEvents = new ArrayBlockingQueue<CustomEvent>(128);

    public CustomEvent pollEvent(ClientEvent.Type type) {
        try {
            CustomEvent event = this.queue(type).poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((Object)event);
            return event;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private BlockingQueue<CustomEvent> queue(ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                return this.createdCustomEvents;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                return this.modifiedCustomEvents;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                return this.removedCustomEvents;
            }
        }
        throw new IllegalArgumentException("Unknown event type: " + type);
    }

    public void expectNoEvents(ClientEvent.Type type) {
        AssertJUnit.assertEquals((int)0, (int)this.queue(type).size());
    }

    public void expectNoEvents() {
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public void expectSingleCustomEvent(ClientEvent.Type type, Integer key, String value) {
        CustomEvent event = this.pollEvent(type);
        AssertJUnit.assertEquals((Object)key, (Object)event.key);
        AssertJUnit.assertEquals((String)value, (String)event.value);
    }

    public void expectOnlyCreatedCustomEvent(Integer key, String value) {
        this.expectSingleCustomEvent(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, key, value);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public void expectOnlyModifiedCustomEvent(Integer key, String value) {
        this.expectSingleCustomEvent(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED, key, value);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public void expectOnlyRemovedCustomEvent(Integer key, String value) {
        this.expectSingleCustomEvent(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED, key, value);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
    }

    @ClientCacheEntryCreated
    public void handleCustomCreatedEvent(ClientCacheEntryCustomEvent<CustomEvent> e) {
        AssertJUnit.assertEquals((Object)ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, (Object)e.getType());
        this.createdCustomEvents.add((CustomEvent)e.getEventData());
    }

    @ClientCacheEntryModified
    public void handleCustomModifiedEvent(ClientCacheEntryCustomEvent<CustomEvent> e) {
        AssertJUnit.assertEquals((Object)ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED, (Object)e.getType());
        this.modifiedCustomEvents.add((CustomEvent)e.getEventData());
    }

    @ClientCacheEntryRemoved
    public void handleCustomRemovedEvent(ClientCacheEntryCustomEvent<CustomEvent> e) {
        AssertJUnit.assertEquals((Object)ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED, (Object)e.getType());
        this.removedCustomEvents.add((CustomEvent)e.getEventData());
    }

    @NamedFactory(name="dynamic-converter-factory")
    public static class DynamicConverterFactory
    implements CacheEventConverterFactory {
        public CacheEventConverter<Integer, String, CustomEvent> getConverter(Object[] params) {
            return new DynamicConverter(params);
        }

        static class DynamicConverter
        implements CacheEventConverter<Integer, String, CustomEvent>,
        Serializable {
            private final Object[] params;

            public DynamicConverter(Object[] params) {
                this.params = params;
            }

            public CustomEvent convert(Integer key, String previousValue, Metadata previousMetadata, String value, Metadata metadata, EventType eventType) {
                if (this.params[0].equals(key)) {
                    return new CustomEvent(key, null);
                }
                return new CustomEvent(key, value);
            }
        }
    }

    @NamedFactory(name="static-converter-factory")
    public static class StaticConverterFactory
    implements CacheEventConverterFactory {
        public CacheEventConverter<Integer, String, CustomEvent> getConverter(Object[] params) {
            return new StaticConverter();
        }

        static class StaticConverter
        implements CacheEventConverter<Integer, String, CustomEvent>,
        Serializable {
            StaticConverter() {
            }

            public CustomEvent convert(Integer key, String previousValue, Metadata previousMetadata, String value, Metadata metadata, EventType eventType) {
                return new CustomEvent(key, value);
            }
        }
    }

    @ClientListener(converterFactoryName="dynamic-converter-factory", includeCurrentState=true)
    public static class DynamicCustomEventWithStateLogListener
    extends CustomEventLogListener {
    }

    @ClientListener(converterFactoryName="dynamic-converter-factory")
    public static class DynamicCustomEventLogListener
    extends CustomEventLogListener {
    }

    @ClientListener(converterFactoryName="static-converter-factory", includeCurrentState=true)
    public static class StaticCustomEventLogWithStateListener
    extends CustomEventLogListener {
    }

    @ClientListener(converterFactoryName="static-converter-factory")
    public static class StaticCustomEventLogListener
    extends CustomEventLogListener {
    }

    public static class CustomEvent
    implements Serializable {
        final Integer key;
        final String value;

        CustomEvent(Integer key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

