/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientCacheFailover;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.ClientEvent;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterFactory;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.notifications.cachelistener.filter.NamedFactory;
import org.junit.Assert;
import org.testng.AssertJUnit;

@ClientListener
public class EventLogListener<K> {
    public BlockingQueue<ClientCacheEntryCreatedEvent> createdEvents = new ArrayBlockingQueue<ClientCacheEntryCreatedEvent>(128);
    public BlockingQueue<ClientCacheEntryModifiedEvent> modifiedEvents = new ArrayBlockingQueue<ClientCacheEntryModifiedEvent>(128);
    public BlockingQueue<ClientCacheEntryRemovedEvent> removedEvents = new ArrayBlockingQueue<ClientCacheEntryRemovedEvent>(128);
    public BlockingQueue<ClientCacheFailoverEvent> failoverEvents = new ArrayBlockingQueue<ClientCacheFailoverEvent>(128);
    private final boolean compatibility;

    public EventLogListener(boolean compatibility) {
        this.compatibility = compatibility;
    }

    public EventLogListener() {
        this.compatibility = false;
    }

    public <E extends ClientEvent> E pollEvent(ClientEvent.Type type) {
        try {
            ClientEvent event = (ClientEvent)this.queue(type).poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((Object)event);
            return (E)event;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public <E extends ClientEvent> BlockingQueue<E> queue(ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                return this.createdEvents;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                return this.modifiedEvents;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                return this.removedEvents;
            }
            case CLIENT_CACHE_FAILOVER: {
                return this.failoverEvents;
            }
        }
        throw new IllegalArgumentException("Unknown event type: " + type);
    }

    @ClientCacheEntryCreated
    public void handleCreatedEvent(ClientCacheEntryCreatedEvent e) {
        this.createdEvents.add(e);
    }

    @ClientCacheEntryModified
    public void handleModifiedEvent(ClientCacheEntryModifiedEvent e) {
        this.modifiedEvents.add(e);
    }

    @ClientCacheEntryRemoved
    public void handleRemovedEvent(ClientCacheEntryRemovedEvent e) {
        this.removedEvents.add(e);
    }

    @ClientCacheFailover
    public void handleFailover(ClientCacheFailoverEvent e) {
        this.failoverEvents.add(e);
    }

    public void expectNoEvents() {
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public void expectNoEvents(ClientEvent.Type type) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                AssertJUnit.assertEquals((int)0, (int)this.createdEvents.size());
                break;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                AssertJUnit.assertEquals((int)0, (int)this.modifiedEvents.size());
                break;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                AssertJUnit.assertEquals((int)0, (int)this.removedEvents.size());
            }
        }
    }

    public void expectOnlyCreatedEvent(K key, Cache cache) {
        this.expectSingleEvent(key, ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED, cache);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public void expectOnlyModifiedEvent(K key, Cache cache) {
        this.expectSingleEvent(key, ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED, cache);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED);
    }

    public void expectOnlyRemovedEvent(K key, Cache cache) {
        this.expectSingleEvent(key, ClientEvent.Type.CLIENT_CACHE_ENTRY_REMOVED, cache);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_CREATED);
        this.expectNoEvents(ClientEvent.Type.CLIENT_CACHE_ENTRY_MODIFIED);
    }

    public void expectSingleEvent(K key, ClientEvent.Type type, Cache cache) {
        switch (type) {
            case CLIENT_CACHE_ENTRY_CREATED: {
                ClientCacheEntryCreatedEvent createdEvent = (ClientCacheEntryCreatedEvent)this.pollEvent(type);
                Assert.assertEquals(key, (Object)createdEvent.getKey());
                AssertJUnit.assertEquals((long)this.serverDataVersion((Cache<Object, Object>)cache, key), (long)createdEvent.getVersion());
                break;
            }
            case CLIENT_CACHE_ENTRY_MODIFIED: {
                ClientCacheEntryModifiedEvent modifiedEvent = (ClientCacheEntryModifiedEvent)this.pollEvent(type);
                Assert.assertEquals(key, (Object)modifiedEvent.getKey());
                AssertJUnit.assertEquals((long)this.serverDataVersion((Cache<Object, Object>)cache, key), (long)modifiedEvent.getVersion());
                break;
            }
            case CLIENT_CACHE_ENTRY_REMOVED: {
                ClientCacheEntryRemovedEvent removedEvent = (ClientCacheEntryRemovedEvent)this.pollEvent(type);
                Assert.assertEquals(key, (Object)removedEvent.getKey());
            }
        }
        Assert.assertEquals((long)0L, (long)this.queue(type).size());
    }

    private long serverDataVersion(Cache<Object, Object> cache, K key) {
        K lookupKey;
        try {
            lookupKey = this.compatibility ? key : (K)new GenericJBossMarshaller().objectToByteBuffer(key);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        Metadata meta = cache.getAdvancedCache().getCacheEntry(lookupKey).getMetadata();
        return ((NumericVersion)meta.version()).getVersion();
    }

    public void expectUnorderedEvents(ClientEvent.Type type, K ... keys) {
        ArrayList assertedKeys = new ArrayList();
        for (int i = 0; i < keys.length; ++i) {
            Object event = this.pollEvent(type);
            int initialSize = assertedKeys.size();
            for (K key : keys) {
                Object eventKey = null;
                switch (event.getType()) {
                    case CLIENT_CACHE_ENTRY_CREATED: {
                        eventKey = ((ClientCacheEntryCreatedEvent)event).getKey();
                        break;
                    }
                    case CLIENT_CACHE_ENTRY_MODIFIED: {
                        eventKey = ((ClientCacheEntryModifiedEvent)event).getKey();
                        break;
                    }
                    case CLIENT_CACHE_ENTRY_REMOVED: {
                        eventKey = ((ClientCacheEntryRemovedEvent)event).getKey();
                    }
                }
                this.checkUnorderedKeyEvent(assertedKeys, key, eventKey);
            }
            int finalSize = assertedKeys.size();
            AssertJUnit.assertEquals((int)(initialSize + 1), (int)finalSize);
        }
    }

    private boolean checkUnorderedKeyEvent(List<K> assertedKeys, K key, K eventKey) {
        if (key.equals(eventKey)) {
            AssertJUnit.assertFalse((boolean)assertedKeys.contains(key));
            assertedKeys.add(key);
            return true;
        }
        return false;
    }

    public void expectFailoverEvent() {
        this.pollEvent(ClientEvent.Type.CLIENT_CACHE_FAILOVER);
    }

    @NamedFactory(name="dynamic-filter-factory")
    public static class DynamicCacheEventFilterFactory
    implements CacheEventFilterFactory {
        public CacheEventFilter<Integer, String> getFilter(Object[] params) {
            return new DynamicCacheEventFilter(params);
        }

        static class DynamicCacheEventFilter
        implements CacheEventFilter<Integer, String>,
        Serializable {
            private final Object[] params;

            public DynamicCacheEventFilter(Object[] params) {
                this.params = params;
            }

            public boolean accept(Integer key, String previousValue, Metadata previousMetadata, String value, Metadata metadata, EventType eventType) {
                return this.params[0].equals(key);
            }
        }
    }

    @NamedFactory(name="static-filter-factory")
    public static class StaticCacheEventFilterFactory
    implements CacheEventFilterFactory {
        public CacheEventFilter<Integer, String> getFilter(Object[] params) {
            return new StaticCacheEventFilter();
        }

        static class StaticCacheEventFilter
        implements CacheEventFilter<Integer, String>,
        Serializable {
            final Integer staticKey = 2;

            StaticCacheEventFilter() {
            }

            public boolean accept(Integer key, String previousValue, Metadata previousMetadata, String value, Metadata metadata, EventType eventType) {
                return this.staticKey.equals(key);
            }
        }
    }

    @ClientListener(filterFactoryName="dynamic-filter-factory", includeCurrentState=true)
    public static class DynamicFilteredEventLogWithStateListener<K>
    extends EventLogListener<K> {
        public DynamicFilteredEventLogWithStateListener() {
        }

        public DynamicFilteredEventLogWithStateListener(boolean compatibility) {
            super(compatibility);
        }
    }

    @ClientListener(filterFactoryName="dynamic-filter-factory")
    public static class DynamicFilteredEventLogListener<K>
    extends EventLogListener<K> {
        public DynamicFilteredEventLogListener() {
        }

        public DynamicFilteredEventLogListener(boolean compatibility) {
            super(compatibility);
        }
    }

    @ClientListener(filterFactoryName="static-filter-factory", includeCurrentState=true)
    public static class StaticFilteredEventLogWithStateListener<K>
    extends EventLogListener<K> {
        public StaticFilteredEventLogWithStateListener() {
        }

        public StaticFilteredEventLogWithStateListener(boolean compatibility) {
            super(compatibility);
        }
    }

    @ClientListener(filterFactoryName="static-filter-factory")
    public static class StaticFilteredEventLogListener<K>
    extends EventLogListener<K> {
        public StaticFilteredEventLogListener() {
        }

        public StaticFilteredEventLogListener(boolean compatibility) {
            super(compatibility);
        }
    }
}

