/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.EmbeddedAccountMarshaller;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Index;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AccountHS;
import org.infinispan.query.remote.CompatibilityProtoStreamMarshaller;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.EmbeddedCompatTest", groups={"functional"})
@CleanupAfterMethod
public class EmbeddedCompatTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Integer, Account> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.createConfigBuilder();
        builder.dataContainer().keyEquivalence((Equivalence)AnyEquivalence.getInstance());
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = TestHelper.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"google/protobuf/descriptor.proto", (Object)Util.read((InputStream)Util.getResourceAsStream((String)"/google/protobuf/descriptor.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())));
        metadataCache.put((Object)"infinispan/indexing.proto", (Object)Util.read((InputStream)Util.getResourceAsStream((String)"/infinispan/indexing.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())));
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.read((InputStream)Util.getResourceAsStream((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())));
        ProtobufMetadataManager protobufMetadataManager = (ProtobufMetadataManager)this.cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        protobufMetadataManager.registerMarshaller((BaseMarshaller)new EmbeddedAccountMarshaller());
        return this.cacheManager;
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder createConfigBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.compatibility().enable().marshaller((Marshaller)new CompatibilityProtoStreamMarshaller());
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    @AfterTest
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testPutAndGet() throws Exception {
        AccountPB account = this.createAccount();
        this.remoteCache.put((Object)1, (Object)account);
        Assert.assertEquals((long)1L, (long)this.cache.keySet().size());
        Object key = this.cache.keySet().iterator().next();
        Object localObject = this.cache.get(key);
        this.assertEmbeddedAccount((Account)localObject);
        Account fromRemoteCache = (Account)this.remoteCache.get((Object)1);
        this.assertRemoteAccount(fromRemoteCache);
    }

    public void testPutAndGetForEmbeddedEntry() throws Exception {
        AccountHS account = new AccountHS();
        account.setId(1);
        account.setDescription("test description");
        account.setCreationDate(new Date(42L));
        this.cache.put((Object)1, (Object)account);
        Assert.assertEquals((long)1L, (long)this.remoteCache.keySet().size());
        Object key = this.remoteCache.keySet().iterator().next();
        Object remoteObject = this.remoteCache.get(key);
        this.assertRemoteAccount((Account)remoteObject);
        Account fromEmbeddedCache = (Account)this.cache.get((Object)1);
        this.assertEmbeddedAccount(fromEmbeddedCache);
    }

    public void testRemoteQuery() throws Exception {
        AccountPB account = this.createAccount();
        this.remoteCache.put((Object)1, (Object)account);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(AccountPB.class).having("description").like("%test%").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        this.assertRemoteAccount((Account)list.get(0));
    }

    public void testRemoteQueryForEmbeddedEntry() throws Exception {
        AccountHS account = new AccountHS();
        account.setId(1);
        account.setDescription("test description");
        account.setCreationDate(new Date(42L));
        this.cache.put((Object)1, (Object)account);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(AccountPB.class).having("description").like("%test%").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        this.assertRemoteAccount((Account)list.get(0));
    }

    public void testRemoteQueryWithProjectionsForEmbeddedEntry() throws Exception {
        AccountHS account = new AccountHS();
        account.setId(1);
        account.setDescription("test description");
        account.setCreationDate(new Date(42L));
        this.cache.put((Object)1, (Object)account);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(AccountPB.class).setProjection(new String[]{"description", "id"}).having("description").like("%test%").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"test description", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)1, (Object)((Object[])list.get(0))[1]);
    }

    public void testEmbeddedQuery() throws Exception {
        AccountPB account = this.createAccount();
        this.remoteCache.put((Object)1, (Object)account);
        org.apache.lucene.search.Query query = org.infinispan.query.Search.getSearchManager((Cache)this.cache).buildQueryBuilderForClass(AccountHS.class).get().keyword().wildcard().onField("description").matching((Object)"*test*").createQuery();
        CacheQuery cacheQuery = org.infinispan.query.Search.getSearchManager((Cache)this.cache).getQuery(query, new Class[0]);
        List list = cacheQuery.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        this.assertEmbeddedAccount((Account)list.get(0));
    }

    private AccountPB createAccount() {
        AccountPB account = new AccountPB();
        account.setId(1);
        account.setDescription("test description");
        account.setCreationDate(new Date(42L));
        return account;
    }

    private void assertRemoteAccount(Account account) {
        Assert.assertNotNull((Object)account);
        Assert.assertEquals(AccountPB.class, account.getClass());
        Assert.assertEquals((long)1L, (long)account.getId());
        Assert.assertEquals((Object)"test description", (Object)account.getDescription());
        Assert.assertEquals((long)42L, (long)account.getCreationDate().getTime());
    }

    private void assertEmbeddedAccount(Account account) {
        Assert.assertEquals(AccountHS.class, account.getClass());
        Assert.assertEquals((long)1L, (long)account.getId());
        Assert.assertEquals((Object)"test description", (Object)account.getDescription());
        Assert.assertEquals((long)42L, (long)account.getCreationDate().getTime());
    }
}

