/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AddressPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.Address;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.HotRodQueryTest", groups={"functional"})
public class HotRodQueryTest
extends SingleCacheManagerTest {
    protected static final String JMX_DOMAIN = ProtobufMetadataManager.class.getSimpleName();
    protected static final String TEST_CACHE_NAME = "userCache";
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Integer, User> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        gcb.globalJmxStatistics().enable().allowDuplicateDomains(Boolean.valueOf(true)).jmxDomain(JMX_DOMAIN).mBeanServerLookup((MBeanServerLookup)new PerThreadMBeanServerLookup());
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.getConfigurationBuilder();
        this.cacheManager = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)gcb, (org.infinispan.configuration.cache.ConfigurationBuilder)new org.infinispan.configuration.cache.ConfigurationBuilder(), (boolean)true);
        this.cacheManager.defineConfiguration(TEST_CACHE_NAME, builder.build());
        this.cache = this.cacheManager.getCache(TEST_CACHE_NAME);
        this.hotRodServer = TestHelper.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache(TEST_CACHE_NAME);
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"google/protobuf/descriptor.proto", (Object)this.read("/google/protobuf/descriptor.proto"));
        metadataCache.put((Object)"infinispan/indexing.proto", (Object)this.read("/infinispan/indexing.proto"));
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)this.read("/sample_bank_account/bank.proto"));
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
        return this.cacheManager;
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.dataContainer().keyEquivalence(ByteArrayEquivalence.INSTANCE).indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    private String read(String classPathResource) throws IOException {
        return Util.read((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(classPathResource));
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    @BeforeClass(alwaysRun=true)
    protected void populateCache() {
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("Tom");
        user1.setSurname("Cat");
        user1.setGender(User.Gender.MALE);
        user1.setAccountIds(Collections.singleton(12));
        AddressPB address1 = new AddressPB();
        address1.setStreet("Dark Alley");
        address1.setPostCode("1234");
        user1.setAddresses(Collections.singletonList(address1));
        this.remoteCache.put((Object)1, (Object)user1);
        UserPB user2 = new UserPB();
        user2.setId(2);
        user2.setName("Adrian");
        user2.setSurname("Nistor");
        user2.setGender(User.Gender.MALE);
        AddressPB address2 = new AddressPB();
        address2.setStreet("Old Street");
        address2.setPostCode("XYZ");
        user2.setAddresses(Collections.singletonList(address2));
        this.remoteCache.put((Object)2, (Object)user2);
    }

    protected void clearContent() {
    }

    public void testAttributeQuery() throws Exception {
        User fromCache = (User)this.remoteCache.get((Object)1);
        Assert.assertNotNull((Object)fromCache);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(UserPB.class).having("name").eq((Object)"Tom").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    public void testEmbeddedAttributeQuery() throws Exception {
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(UserPB.class).having("addresses.postCode").eq((Object)"1234").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    @Test(enabled=false, expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*HQLLUCN000005:.*", description="See https://issues.jboss.org/browse/ISPN-4423")
    public void testInvalidEmbeddedAttributeQuery() throws Exception {
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query q = qf.from(UserPB.class).setProjection(new String[]{"addresses"}).build();
        q.list();
    }

    public void testProjections() throws Exception {
        User fromCache = (User)this.remoteCache.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache);
        Query query = qf.from(UserPB.class).setProjection(new String[]{"name", "surname"}).having("name").eq((Object)"Tom").toBuilder().build();
        List list = query.list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        Assert.assertEquals((Object)"Tom", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Cat", (Object)((Object[])list.get(0))[1]);
    }

    private void assertUser1(User user) {
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((long)1L, (long)user.getId());
        Assert.assertEquals((Object)"Tom", (Object)user.getName());
        Assert.assertEquals((Object)"Cat", (Object)user.getSurname());
        Assert.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        Assert.assertNotNull((Object)user.getAccountIds());
        Assert.assertEquals((long)1L, (long)user.getAccountIds().size());
        Assert.assertTrue((boolean)user.getAccountIds().contains(12));
        Assert.assertNotNull((Object)user.getAddresses());
        Assert.assertEquals((long)1L, (long)user.getAddresses().size());
        Assert.assertEquals((Object)"Dark Alley", (Object)((Address)user.getAddresses().get(0)).getStreet());
        Assert.assertEquals((Object)"1234", (Object)((Address)user.getAddresses().get(0)).getPostCode());
    }
}

