/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.io.InputStream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.ModelFactoryPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.MarshallerRegistration;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Index;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.QueryDslIterationTest;
import org.infinispan.query.dsl.embedded.testdomain.ModelFactory;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.RemoteQueryDslIterationTest")
public class RemoteQueryDslIterationTest
extends QueryDslIterationTest {
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;

    protected QueryFactory getQueryFactory() {
        return Search.getQueryFactory(this.remoteCache);
    }

    protected ModelFactory getModelFactory() {
        return ModelFactoryPB.INSTANCE;
    }

    protected BasicCache<Object, Object> getCacheForQuery() {
        return this.remoteCache;
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.getConfigurationBuilder();
        this.createClusteredCaches(1, builder);
        this.hotRodServer = TestHelper.startHotRodServer(this.manager(0));
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        RemoteCache metadataCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"google/protobuf/descriptor.proto", (Object)Util.read((InputStream)Util.getResourceAsStream((String)"/google/protobuf/descriptor.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())));
        metadataCache.put((Object)"infinispan/indexing.proto", (Object)Util.read((InputStream)Util.getResourceAsStream((String)"/infinispan/indexing.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())));
        metadataCache.put((Object)"sample_bank_account/bank.proto", (Object)Util.read((InputStream)Util.getResourceAsStream((String)"/sample_bank_account/bank.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())));
        MarshallerRegistration.registerMarshallers(ProtoStreamMarshaller.getSerializationContext((RemoteCacheManager)this.remoteCacheManager));
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.indexing().index(Index.ALL).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testIteration1() {
    }

    public void testIteration2() {
    }

    public void testIteration3() {
    }

    public void testIteration4() {
    }

    public void testIteration5() {
    }
}

