/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.net.SocketAddress;
import java.util.Properties;
import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;

public abstract class AbstractRetryTest
extends HitsAwareCacheManagersTest {
    protected HotRodServer hotRodServer1;
    protected HotRodServer hotRodServer2;
    protected HotRodServer hotRodServer3;
    RemoteCacheImpl<Object, Object> remoteCache;
    protected RemoteCacheManager remoteCacheManager;
    protected TcpTransportFactory tcpConnectionFactory;
    protected ConfigurationBuilder config;
    protected RoundRobinBalancingStrategy strategy;

    public AbstractRetryTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void assertSupportedConfig() {
    }

    protected void createCacheManagers() throws Throwable {
        this.config = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)this.getCacheConfig());
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.config);
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.config);
        EmbeddedCacheManager cm3 = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.config);
        this.registerCacheManager(new CacheContainer[]{cm1});
        this.registerCacheManager(new CacheContainer[]{cm2});
        this.registerCacheManager(new CacheContainer[]{cm3});
        this.hotRodServer1 = TestHelper.startHotRodServer(this.manager(0));
        this.hrServ2CacheManager.put(this.getAddress(this.hotRodServer1), cm1);
        this.hotRodServer2 = TestHelper.startHotRodServer(this.manager(1));
        this.hrServ2CacheManager.put(this.getAddress(this.hotRodServer2), cm2);
        this.hotRodServer3 = TestHelper.startHotRodServer(this.manager(2));
        this.hrServ2CacheManager.put(this.getAddress(this.hotRodServer3), cm3);
        this.waitForClusterToForm();
        Properties clientConfig = new Properties();
        clientConfig.put("infinispan.client.hotrod.server_list", "localhost:" + this.hotRodServer2.getPort());
        clientConfig.put("infinispan.client.hotrod.force_return_values", "true");
        clientConfig.put("infinispan.client.hotrod.connect_timeout", "5");
        clientConfig.put("maxActive", (Object)1);
        this.remoteCacheManager = new RemoteCacheManager(clientConfig);
        this.remoteCache = (RemoteCacheImpl)this.remoteCacheManager.getCache();
        this.tcpConnectionFactory = (TcpTransportFactory)TestingUtil.extractField((Object)this.remoteCacheManager, (String)"transportFactory");
        this.strategy = (RoundRobinBalancingStrategy)this.tcpConnectionFactory.getBalancer(RemoteCacheManager.cacheNameBytes());
        this.addInterceptors();
        assert (this.cacheManagers.size() == 3);
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        if (this.cleanupAfterMethod()) {
            HotRodClientTestingUtil.killRemoteCacheManagers(this.remoteCacheManager);
            HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2, this.hotRodServer3);
        }
        super.clearContent();
    }

    protected abstract ConfigurationBuilder getCacheConfig();

    protected AdvancedCache<?, ?> nextCacheToHit() {
        SocketAddress expectedServer = this.strategy.getServers()[this.strategy.getNextPosition()];
        return ((EmbeddedCacheManager)this.hrServ2CacheManager.get(expectedServer)).getCache().getAdvancedCache();
    }
}

