/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import org.infinispan.client.hotrod.TestHelper;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.retry.ServerFailureRetrySingleOwnerTest")
public class ServerFailureRetrySingleOwnerTest
extends AbstractRetryTest {
    public ServerFailureRetrySingleOwnerTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_TEST;
    }

    @Override
    protected ConfigurationBuilder getCacheConfig() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)ServerFailureRetrySingleOwnerTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.clustering().hash().numOwners(1).numSegments(1).consistentHashFactory((ConsistentHashFactory)new ControlledConsistentHashFactory(0, new int[0])).transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        return builder;
    }

    public void testRetryReplaceWithVersion() {
        final ErrorInducingListener listener = new ErrorInducingListener();
        final byte[] key = TestHelper.getKeyForServer(this.hotRodServer1);
        AssertJUnit.assertNull((Object)this.remoteCache.putIfAbsent((Object)key, (Object)1));
        final VersionedValue versioned = this.remoteCache.getVersioned((Object)key);
        AssertJUnit.assertEquals((Object)1, (Object)versioned.getValue());
        this.withListener(listener, new Runnable(){

            @Override
            public void run() {
                AssertJUnit.assertFalse((boolean)listener.errorInduced);
                AssertJUnit.assertEquals((boolean)true, (boolean)ServerFailureRetrySingleOwnerTest.this.remoteCache.replaceWithVersion((Object)key, (Object)2, versioned.getVersion()));
                AssertJUnit.assertTrue((boolean)listener.errorInduced);
                AssertJUnit.assertEquals((Object)2, (Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.get((Object)key));
            }
        });
    }

    public void testRetryRemoveWithVersion() {
        final ErrorInducingListener listener = new ErrorInducingListener();
        final byte[] key = TestHelper.getKeyForServer(this.hotRodServer1);
        AssertJUnit.assertNull((Object)this.remoteCache.putIfAbsent((Object)key, (Object)1));
        final VersionedValue versioned = this.remoteCache.getVersioned((Object)key);
        AssertJUnit.assertEquals((Object)1, (Object)versioned.getValue());
        this.withListener(listener, new Runnable(){

            @Override
            public void run() {
                AssertJUnit.assertFalse((boolean)listener.errorInduced);
                AssertJUnit.assertEquals((boolean)true, (boolean)ServerFailureRetrySingleOwnerTest.this.remoteCache.removeWithVersion((Object)key, versioned.getVersion()));
                AssertJUnit.assertTrue((boolean)listener.errorInduced);
                AssertJUnit.assertNull((Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.get((Object)key));
            }
        });
    }

    public void testRetryRemove() {
        final ErrorInducingListener listener = new ErrorInducingListener();
        final byte[] key = TestHelper.getKeyForServer(this.hotRodServer1);
        AssertJUnit.assertNull((Object)this.remoteCache.putIfAbsent((Object)key, (Object)1));
        this.withListener(listener, new Runnable(){

            @Override
            public void run() {
                AssertJUnit.assertFalse((boolean)listener.errorInduced);
                AssertJUnit.assertEquals((Object)1, (Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.remove((Object)key));
                AssertJUnit.assertTrue((boolean)listener.errorInduced);
                AssertJUnit.assertNull((Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.get((Object)key));
            }
        });
    }

    public void testRetryReplace() {
        final ErrorInducingListener listener = new ErrorInducingListener();
        final byte[] key = TestHelper.getKeyForServer(this.hotRodServer1);
        AssertJUnit.assertNull((Object)this.remoteCache.putIfAbsent((Object)key, (Object)1));
        this.withListener(listener, new Runnable(){

            @Override
            public void run() {
                AssertJUnit.assertFalse((boolean)listener.errorInduced);
                AssertJUnit.assertEquals((Object)1, (Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.replace((Object)key, (Object)2));
                AssertJUnit.assertTrue((boolean)listener.errorInduced);
                AssertJUnit.assertEquals((Object)2, (Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.get((Object)key));
            }
        });
    }

    public void testRetryPutIfAbsent() {
        final ErrorInducingListener listener = new ErrorInducingListener();
        final byte[] key = TestHelper.getKeyForServer(this.hotRodServer1);
        this.withListener(listener, new Runnable(){

            @Override
            public void run() {
                AssertJUnit.assertFalse((boolean)listener.errorInduced);
                AssertJUnit.assertNull((Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.putIfAbsent((Object)key, (Object)1));
                AssertJUnit.assertTrue((boolean)listener.errorInduced);
                AssertJUnit.assertEquals((Object)1, (Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.get((Object)key));
            }
        });
    }

    public void testRetryPutOnNonEmpty() {
        final ErrorInducingListener listener = new ErrorInducingListener();
        final byte[] key = TestHelper.getKeyForServer(this.hotRodServer1);
        AssertJUnit.assertNull((Object)this.remoteCache.put((Object)key, (Object)1));
        this.withListener(listener, new Runnable(){

            @Override
            public void run() {
                AssertJUnit.assertFalse((boolean)listener.errorInduced);
                AssertJUnit.assertEquals((Object)1, (Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.put((Object)key, (Object)2));
                AssertJUnit.assertTrue((boolean)listener.errorInduced);
                AssertJUnit.assertEquals((Object)2, (Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.get((Object)key));
            }
        });
    }

    public void testRetryPutOnEmpty() {
        final ErrorInducingListener listener = new ErrorInducingListener();
        final byte[] key = TestHelper.getKeyForServer(this.hotRodServer1);
        this.withListener(listener, new Runnable(){

            @Override
            public void run() {
                AssertJUnit.assertFalse((boolean)listener.errorInduced);
                AssertJUnit.assertNull((Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.put((Object)key, (Object)1));
                AssertJUnit.assertTrue((boolean)listener.errorInduced);
                AssertJUnit.assertEquals((Object)1, (Object)ServerFailureRetrySingleOwnerTest.this.remoteCache.get((Object)key));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withListener(Object listener, Runnable r) {
        this.hotRodServer1.getCacheManager().getCache().addListener(listener);
        try {
            r.run();
        }
        finally {
            this.hotRodServer1.getCacheManager().getCache().removeListener(listener);
        }
    }

    @Listener
    public static class ErrorInducingListener {
        boolean errorInduced;

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        public void handleEvent(CacheEntryEvent event) throws Exception {
            if (!event.isPre() && event.isOriginLocal()) {
                this.errorInduced = true;
                throw new SuspectException("Simulated suspicion");
            }
        }
    }
}

