/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.impl.transport.tcp.RoundRobinBalancingStrategy;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.DistKeepRunningWithTopologyChangeTest")
public class DistTopologyChangeUnderLoadTest
extends MultiHotRodServersTest {
    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(1, this.getCacheConfiguration());
    }

    private ConfigurationBuilder getCacheConfiguration() {
        ConfigurationBuilder builder = DistTopologyChangeUnderLoadTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(2);
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder);
    }

    public void testPutsSucceedWhileTopologyChanges() throws Exception {
        RemoteCache remote = this.client(0).getCache();
        remote.put((Object)1, (Object)"v1");
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)1)));
        PutHammer putHammer = new PutHammer();
        Future putHammerFuture = this.fork(putHammer);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager((ConfigurationBuilder)this.getCacheConfiguration());
        this.registerCacheManager(new CacheContainer[]{cm});
        HotRodClientTestingUtil.startHotRodServer(cm);
        this.waitForClusterToForm();
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{cm.getCache(), this.cache(0)});
        TestingUtil.sleepThread((long)2000L);
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cm});
        TestingUtil.waitForRehashToComplete((Cache[])new Cache[]{this.cache(0)});
        RoundRobinBalancingStrategy strategy = (RoundRobinBalancingStrategy)HotRodClientTestingUtil.getLoadBalancer(this.client(0));
        SocketAddress[] servers = strategy.getServers();
        putHammer.stop = true;
        putHammerFuture.get();
        AssertJUnit.assertEquals((int)1, (int)servers.length);
    }

    private class PutHammer
    implements Callable<Void> {
        volatile boolean stop;

        private PutHammer() {
        }

        @Override
        public Void call() throws Exception {
            RemoteCache remote = DistTopologyChangeUnderLoadTest.this.client(0).getCache();
            int i = 2;
            while (!this.stop) {
                remote.put((Object)i, (Object)("v" + i));
                ++i;
            }
            for (int j = i + 1; j < i + 100; ++j) {
                remote.put((Object)j, (Object)("v" + j));
            }
            return null;
        }
    }
}

