/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.BeforeMethod;

public abstract class HitsAwareCacheManagersTest
extends MultipleCacheManagersTest {
    protected Map<SocketAddress, EmbeddedCacheManager> hrServ2CacheManager = new HashMap<SocketAddress, EmbeddedCacheManager>();
    protected Map<SocketAddress, HotRodServer> addr2hrServer = new HashMap<SocketAddress, HotRodServer>();

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() throws Throwable {
        if (this.cleanupAfterMethod()) {
            this.hrServ2CacheManager.clear();
            this.addr2hrServer.clear();
        }
        super.createBeforeMethod();
    }

    protected HitCountInterceptor getHitCountInterceptor(Cache<?, ?> cache) {
        HitCountInterceptor hitCountInterceptor = null;
        List interceptorChain = cache.getAdvancedCache().getInterceptorChain();
        for (CommandInterceptor interceptor : interceptorChain) {
            boolean isHitCountInterceptor = interceptor instanceof HitCountInterceptor;
            if (hitCountInterceptor != null && isHitCountInterceptor) {
                throw new IllegalStateException("Two HitCountInterceptors! " + interceptorChain);
            }
            if (!isHitCountInterceptor) continue;
            hitCountInterceptor = (HitCountInterceptor)interceptor;
        }
        return hitCountInterceptor;
    }

    protected void assertOnlyServerHit(SocketAddress serverAddress) {
        this.assertServerHit(serverAddress, null, 1);
    }

    protected void assertServerHit(SocketAddress serverAddress, String cacheName, int expectedHits) {
        CacheContainer cacheContainer = (CacheContainer)this.hrServ2CacheManager.get(serverAddress);
        HitCountInterceptor interceptor = this.getHitCountInterceptor(this.namedCache(cacheName, cacheContainer));
        assert (interceptor.getHits() == expectedHits) : "Expected " + expectedHits + " hit(s) for " + serverAddress + " but received " + interceptor.getHits();
        for (CacheContainer cacheContainer2 : this.hrServ2CacheManager.values()) {
            if (cacheContainer2 == cacheContainer) continue;
            interceptor = this.getHitCountInterceptor(this.namedCache(cacheName, cacheContainer2));
            assert (interceptor.getHits() == 0) : "Expected 0 hits in " + serverAddress + " but got " + interceptor.getHits();
        }
    }

    private Cache<?, ?> namedCache(String cacheName, CacheContainer cacheContainer) {
        return cacheName == null ? cacheContainer.getCache() : cacheContainer.getCache(cacheName);
    }

    protected void assertNoHits() {
        for (CacheContainer cacheContainer : this.hrServ2CacheManager.values()) {
            HitCountInterceptor interceptor = this.getHitCountInterceptor(cacheContainer.getCache());
            assert (interceptor.getHits() == 0) : "Expected 0 hits but got " + interceptor.getHits();
        }
    }

    protected InetSocketAddress getAddress(HotRodServer hotRodServer) {
        InetSocketAddress socketAddress = new InetSocketAddress(hotRodServer.getHost(), hotRodServer.getPort());
        this.addr2hrServer.put(socketAddress, hotRodServer);
        return socketAddress;
    }

    protected void resetStats() {
        for (EmbeddedCacheManager manager : this.cacheManagers) {
            HitCountInterceptor cmi = this.getHitCountInterceptor(manager.getCache());
            cmi.reset();
        }
    }

    protected void addInterceptors() {
        this.addInterceptors(null);
    }

    protected void addInterceptors(String cacheName) {
        for (EmbeddedCacheManager manager : this.cacheManagers) {
            Cache<?, ?> cache = this.namedCache(cacheName, (CacheContainer)manager);
            this.addHitCountInterceptor(cache);
        }
    }

    private void addHitCountInterceptor(Cache<?, ?> cache) {
        HitCountInterceptor interceptor = new HitCountInterceptor();
        cache.getAdvancedCache().addInterceptor((CommandInterceptor)interceptor, 1);
    }

    public static class HitCountInterceptor
    extends CommandInterceptor {
        private volatile int invocationCount;

        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            if (ctx.isOriginLocal()) {
                ++this.invocationCount;
            }
            return super.handleDefault(ctx, command);
        }

        public int getHits() {
            return this.invocationCount;
        }

        public void reset() {
            this.invocationCount = 0;
        }
    }
}

