/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.interceptors.base.BaseCustomInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.LockingTest", groups={"functional"})
@CleanupAfterTest
public class LockingTest
extends SingleCacheManagerTest {
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotrodServer;

    public void testPerEntryLockContainer() throws Exception {
        this.doLockTest(CacheName.PER_ENTRY_LOCK);
    }

    public void testStrippedLockContainer() throws Exception {
        this.doLockTest(CacheName.STRIPPED_LOCK);
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        super.teardown();
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.locking().lockAcquisitionTimeout(100L, TimeUnit.MILLISECONDS);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
        for (CacheName cacheName : CacheName.values()) {
            cacheName.configure(builder);
            cacheManager.defineConfiguration(cacheName.name(), builder.build());
        }
        return cacheManager;
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        this.remoteCacheManager = new RemoteCacheManager("localhost", this.hotrodServer.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLockTest(CacheName cacheName) throws Exception {
        final RemoteCache remoteCache = this.remoteCacheManager.getCache(cacheName.name());
        CheckPoint checkPoint = this.injectBlockingCommandInterceptor(cacheName.name());
        Future op = this.fork(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                remoteCache.put((Object)"key", (Object)"value1");
                return null;
            }
        });
        checkPoint.awaitStrict("before-block", 30L, TimeUnit.SECONDS);
        try {
            for (int i = 0; i < 50; ++i) {
                try {
                    remoteCache.put((Object)"key", (Object)("value" + i));
                    AssertJUnit.fail((String)"It should have fail with lock timeout!");
                    continue;
                }
                catch (Exception e) {
                    this.log.trace((Object)"Exception caught", (Throwable)e);
                    if (e.getLocalizedMessage().contains("Unable to acquire lock after")) continue;
                    throw e;
                }
            }
        }
        finally {
            checkPoint.trigger("block");
        }
        op.get();
        AssertJUnit.assertEquals((String)"value1", (String)((String)remoteCache.get((Object)"key")));
    }

    private CheckPoint injectBlockingCommandInterceptor(String cacheName) {
        AdvancedCache advancedCache = this.cache(cacheName).getAdvancedCache();
        final CheckPoint checkPoint = new CheckPoint();
        advancedCache.addInterceptorBefore((CommandInterceptor)new BaseCustomInterceptor(){
            private final AtomicBoolean first = new AtomicBoolean(false);

            public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
                if (this.first.compareAndSet(false, true)) {
                    checkPoint.trigger("before-block");
                    checkPoint.awaitStrict("block", 30L, TimeUnit.SECONDS);
                }
                return this.invokeNextInterceptor(ctx, (VisitableCommand)command);
            }
        }, CallInterceptor.class);
        return checkPoint;
    }

    private static enum CacheName {
        STRIPPED_LOCK{

            @Override
            void configure(ConfigurationBuilder builder) {
                builder.locking().useLockStriping(true);
            }
        }
        ,
        PER_ENTRY_LOCK{

            @Override
            void configure(ConfigurationBuilder builder) {
                builder.locking().useLockStriping(false);
            }
        };


        abstract void configure(ConfigurationBuilder var1);
    }
}

