/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.RemoteAsyncAPITest")
public class RemoteAsyncAPITest
extends SingleCacheManagerTest {
    private HotRodServer hotrodServer;
    private RemoteCacheManager rcm;
    private RemoteCache<String, String> c;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        Properties props = new Properties();
        props.put("infinispan.client.hotrod.server_list", "127.0.0.1:" + this.hotrodServer.getPort());
        props.put("infinispan.client.hotrod.force_return_values", "true");
        props.put("testOnBorrow", "false");
        this.rcm = new RemoteCacheManager(props);
        this.c = this.rcm.getCache(true);
    }

    @AfterClass
    protected void destroyAfterClass() {
        super.destroyAfterClass();
        HotRodClientTestingUtil.killRemoteCacheManager(this.rcm);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
    }

    public void testPutAsync() throws Exception {
        NotifyingFuture f = this.c.putAsync((Object)"k", (Object)"v");
        this.testFuture((Future)f, null);
        this.testK("v");
        f = this.c.putAsync((Object)"k", (Object)"v2");
        this.testFuture((Future)f, (Object)"v");
        this.testK("v2");
    }

    public void testPutAsyncWithListener() throws Exception {
        NotifyingFuture f = this.c.putAsync((Object)"k", (Object)"v");
        this.testFutureWithListener(f, null);
        this.testK("v");
        f = this.c.putAsync((Object)"k", (Object)"v2");
        this.testFutureWithListener(f, "v");
        this.testK("v2");
    }

    public void testPutAllAsync() throws Exception {
        NotifyingFuture f = this.c.putAllAsync(Collections.singletonMap("k", "v3"));
        this.testFuture((Future)f, null);
        this.testK("v3");
    }

    public void testPutAllAsyncWithListener() throws Exception {
        NotifyingFuture f = this.c.putAllAsync(Collections.singletonMap("k", "v3"));
        this.testFutureWithListener(f, null);
        this.testK("v3");
    }

    public void testPutIfAbsentAsync() throws Exception {
        this.c.put((Object)"k", (Object)"v3");
        this.testK("v3");
        NotifyingFuture f = this.c.putIfAbsentAsync((Object)"k", (Object)"v4");
        this.testFuture((Future)f, (Object)"v3");
        Assert.assertEquals((Object)"v3", (Object)this.c.remove((Object)"k"));
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v5");
        this.testFuture((Future)f, null);
        this.testK("v5");
    }

    public void testPutIfAbsentAsyncWithListener() throws Exception {
        this.c.put((Object)"k", (Object)"v3");
        this.testK("v3");
        NotifyingFuture f = this.c.putIfAbsentAsync((Object)"k", (Object)"v4");
        this.testFutureWithListener(f, "v3");
        Assert.assertEquals((Object)"v3", (Object)this.c.remove((Object)"k"));
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v5");
        this.testFutureWithListener(f, null);
        this.testK("v5");
    }

    public void testRemoveAsync() throws Exception {
        this.c.put((Object)"k", (Object)"v3");
        this.testK("v3");
        NotifyingFuture f = this.c.removeAsync((Object)"k");
        this.testFuture((Future)f, (Object)"v3");
        this.testK(null);
    }

    public void testRemoveAsyncWithListener() throws Exception {
        this.c.put((Object)"k", (Object)"v3");
        this.testK("v3");
        NotifyingFuture f = this.c.removeAsync((Object)"k");
        this.testFutureWithListener(f, "v3");
        this.testK(null);
    }

    public void testGetAsync() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        this.testK("v");
        NotifyingFuture f = this.c.getAsync((Object)"k");
        this.testFuture((Future)f, (Object)"v");
        this.testK("v");
    }

    public void testGetAsyncWithListener() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        this.testK("v");
        NotifyingFuture f = this.c.getAsync((Object)"k");
        this.testFutureWithListener(f, "v");
    }

    public void testRemoveWithVersionAsync() throws Exception {
        this.c.put((Object)"k", (Object)"v4");
        VersionedValue value = this.c.getVersioned((Object)"k");
        NotifyingFuture f = this.c.removeWithVersionAsync((Object)"k", value.getVersion() + 1L);
        this.testFuture((Future)f, false);
        this.testK("v4");
        f = this.c.removeWithVersionAsync((Object)"k", value.getVersion());
        this.testFuture((Future)f, true);
        this.testK(null);
    }

    public void testRemoveWithVersionAsyncWithListener() throws Exception {
        this.c.put((Object)"k", (Object)"v4");
        VersionedValue value = this.c.getVersioned((Object)"k");
        NotifyingFuture f = this.c.removeWithVersionAsync((Object)"k", value.getVersion() + 1L);
        this.testFutureWithListener(f, false);
        this.testK("v4");
        f = this.c.removeWithVersionAsync((Object)"k", value.getVersion());
        this.testFutureWithListener(f, true);
        this.testK(null);
    }

    public void testReplaceAsync() throws Exception {
        this.testK(null);
        NotifyingFuture f = this.c.replaceAsync((Object)"k", (Object)"v5");
        this.testFuture((Future)f, null);
        this.testK(null);
        this.c.put((Object)"k", (Object)"v");
        this.testK("v");
        f = this.c.replaceAsync((Object)"k", (Object)"v5");
        this.testFuture((Future)f, (Object)"v");
        this.testK("v5");
    }

    public void testReplaceAsyncWithListener() throws Exception {
        this.testK(null);
        NotifyingFuture f = this.c.replaceAsync((Object)"k", (Object)"v5");
        this.testFutureWithListener(f, null);
        this.testK(null);
        this.c.put((Object)"k", (Object)"v");
        this.testK("v");
        f = this.c.replaceAsync((Object)"k", (Object)"v5");
        this.testFutureWithListener(f, "v");
        this.testK("v5");
    }

    public void testReplaceWithVersionAsync() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        VersionedValue versioned1 = this.c.getVersioned((Object)"k");
        NotifyingFuture f = this.c.replaceWithVersionAsync((Object)"k", (Object)"v2", versioned1.getVersion());
        this.testFuture((Future)f, true);
        VersionedValue versioned2 = this.c.getVersioned((Object)"k");
        org.testng.Assert.assertNotEquals((Object)versioned1.getVersion(), (Object)versioned2.getVersion());
        Assert.assertEquals((Object)versioned2.getValue(), (Object)"v2");
        f = this.c.replaceWithVersionAsync((Object)"k", (Object)"v3", versioned1.getVersion());
        this.testFuture((Future)f, false);
        this.testK("v2");
    }

    public void testReplaceWithVersionAsyncWithListener() throws Exception {
        this.c.put((Object)"k", (Object)"v");
        VersionedValue versioned1 = this.c.getVersioned((Object)"k");
        NotifyingFuture f = this.c.replaceWithVersionAsync((Object)"k", (Object)"v2", versioned1.getVersion());
        this.testFutureWithListener(f, true);
        VersionedValue versioned2 = this.c.getVersioned((Object)"k");
        org.testng.Assert.assertNotEquals((Object)versioned1.getVersion(), (Object)versioned2.getVersion());
        Assert.assertEquals((Object)versioned2.getValue(), (Object)"v2");
        f = this.c.replaceWithVersionAsync((Object)"k", (Object)"v3", versioned1.getVersion());
        this.testFutureWithListener(f, false);
        this.testK("v2");
    }

    private <T> void testK(T expected) {
        Assert.assertEquals(expected, (Object)this.c.get((Object)"k"));
    }

    private <T> void testFuture(Future<T> f, T expected) throws ExecutionException, InterruptedException {
        Assert.assertNotNull(f);
        Assert.assertFalse((boolean)f.isCancelled());
        T value = f.get();
        Assert.assertEquals((String)("Obtained " + value), expected, value);
        Assert.assertTrue((boolean)f.isDone());
    }

    private <T> void testFutureWithListener(NotifyingFuture<T> f, T expected) throws InterruptedException {
        Assert.assertNotNull(f);
        AtomicReference ex = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        f.attachListener(new TestingListener(expected, ex, latch));
        if (!latch.await(5L, TimeUnit.SECONDS)) {
            Assert.fail((String)"Not finished within 5 seconds");
        }
        if (ex.get() != null) {
            throw new AssertionError(ex.get());
        }
    }

    private static class TestingListener<T>
    implements FutureListener<T> {
        private final T expected;
        private final AtomicReference<Throwable> exception;
        private final CountDownLatch latch;

        private TestingListener(T expected, AtomicReference<Throwable> exception, CountDownLatch latch) {
            this.expected = expected;
            this.exception = exception;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void futureDone(Future<T> future) {
            try {
                Assert.assertNotNull(future);
                Assert.assertFalse((boolean)future.isCancelled());
                Assert.assertTrue((boolean)future.isDone());
                T value = future.get();
                Assert.assertEquals((String)("Obtained " + value), this.expected, value);
            }
            catch (Throwable t) {
                this.exception.set(t);
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

