/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.remote.CompatibilityProtoStreamMarshaller;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.PrimitiveEmbeddedCompatTest", groups={"functional"})
@CleanupAfterMethod
public class PrimitiveEmbeddedCompatTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = this.createConfigBuilder();
        builder.dataContainer().keyEquivalence((Equivalence)AnyEquivalence.getInstance());
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder createConfigBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.compatibility().enable().marshaller((Marshaller)new CompatibilityProtoStreamMarshaller());
        return builder;
    }

    @AfterTest
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testRemotePutAndGet() throws Exception {
        this.remoteCache.put((Object)1, (Object)"foo");
        Object remoteObject = this.remoteCache.get((Object)1);
        Assert.assertEquals((Object)"foo", (Object)remoteObject);
        Assert.assertEquals((long)1L, (long)this.cache.keySet().size());
        Object key = this.cache.keySet().iterator().next();
        Object localObject = this.cache.get(key);
        Assert.assertEquals((Object)"foo", (Object)localObject);
    }

    public void testLocalPutAndGet() throws Exception {
        this.cache.put((Object)1, (Object)"bar");
        Object localObject = this.cache.get((Object)1);
        Assert.assertEquals((Object)"bar", (Object)localObject);
        Assert.assertEquals((long)1L, (long)this.remoteCache.keySet().size());
        Object key = this.remoteCache.keySet().iterator().next();
        Object remoteObject = this.remoteCache.get(key);
        Assert.assertEquals((Object)"bar", (Object)remoteObject);
    }
}

