/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.ProtoStreamMarshaller;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.marshall.PrimitiveProtoStreamMarshallerTest", groups={"functional"})
@CleanupAfterMethod
public class PrimitiveProtoStreamMarshallerTest
extends SingleCacheManagerTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cache = this.cacheManager.getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort());
        clientBuilder.marshaller((Marshaller)new ProtoStreamMarshaller());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    @AfterTest
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotRodServer);
    }

    public void testPutAndGet() throws Exception {
        this.remoteCache.put((Object)1, (Object)"foo");
        Assert.assertTrue((boolean)this.remoteCache.keySet().contains(1));
        Assert.assertEquals((long)1L, (long)this.cache.keySet().size());
        byte[] key = (byte[])this.cache.keySet().iterator().next();
        Object localObject = this.cache.get((Object)key);
        Assert.assertNotNull((Object)localObject);
        Assert.assertTrue((boolean)(localObject instanceof byte[]));
        Object fromRemoteCache = this.remoteCache.get((Object)1);
        Assert.assertEquals((Object)"foo", (Object)fromRemoteCache);
    }
}

