/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.ArrayList;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.event.StickyServerLoadBalancingStrategy;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.EagerFailoverNearCacheTest")
public class EagerFailoverNearCacheTest
extends MultiHotRodServersTest {
    List<AssertsNearCache<Integer, String>> assertClients = new ArrayList<AssertsNearCache<Integer, String>>(2);

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(2, this.getCacheConfiguration());
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfiguration() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = EagerFailoverNearCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(2);
        return HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
    }

    @Override
    protected RemoteCacheManager createClient(int i) {
        AssertsNearCache asserts = this.createStickyAssertClient();
        this.assertClients.add(asserts);
        return asserts.manager;
    }

    protected <K, V> AssertsNearCache<K, V> createStickyAssertClient() {
        ConfigurationBuilder clientBuilder = new ConfigurationBuilder();
        for (HotRodServer server : this.servers) {
            clientBuilder.addServer().host("127.0.0.1").port(server.getPort());
        }
        clientBuilder.balancingStrategy(StickyServerLoadBalancingStrategy.class);
        clientBuilder.nearCache().mode(this.getNearCacheMode());
        return AssertsNearCache.create(this.cache(0), clientBuilder);
    }

    protected NearCacheMode getNearCacheMode() {
        return NearCacheMode.EAGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNearCacheClearedUponFailover() {
        AssertsNearCache<Integer, String> stickyClient = this.createStickyAssertClient();
        try {
            stickyClient.put(1, "v1").expectNearPut(1, "v1", this.headClient(), this.tailClient());
            stickyClient.put(2, "v1").expectNearPut(2, "v1", this.headClient(), this.tailClient());
            stickyClient.put(3, "v1").expectNearPut(3, "v1", this.headClient(), this.tailClient());
            HotRodClientTestingUtil.findServerAndKill(stickyClient.manager, this.servers, this.cacheManagers);
            stickyClient.get(1, "v1").expectNearClear(new AssertsNearCache[0]).expectNearPutIfAbsent(1, "v1");
            this.headClient().get(2, "v1").expectNearClear(new AssertsNearCache[0]).expectNearPutIfAbsent(2, "v1");
            this.tailClient().get(3, "v1").expectNearClear(new AssertsNearCache[0]).expectNearPutIfAbsent(3, "v1");
        }
        finally {
            stickyClient.stop();
        }
    }

    protected AssertsNearCache<Integer, String> tailClient() {
        return this.assertClients.get(1);
    }

    protected AssertsNearCache<Integer, String> headClient() {
        return this.assertClients.get(0);
    }
}

